//
//  PhobosDataManager.h
//  GMCache
//
//  Created by Locus on 2020/1/21.
//

#import <Foundation/Foundation.h>
#import <MagicalRecord/MagicalRecord.h>
#import "PhobosSendDataEntity+CoreDataClass.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, PhobosDataSendStatus) {
    PhobosDataSendStatusToBeSend       = 1, // 待发送数据
    PhobosDataSendStatusSending        = 2, // 发送中数据
    PhobosDataSendStatusFinish         = 3, // 发送完成数据
    PhobosDataSendStatusError          = 4, // 发送失败数据
};

@interface PhobosDataManager : NSObject

/** 获取待发送数据，包含待发送数据和发送失败数据 */
+ (NSArray<PhobosSendDataEntity *> *)fetchToBeSendDataEntities;

/**
 * 通过 searchFilter 获取数据
 */
+ (NSArray<PhobosSendDataEntity *> *)fetchDataEntitiesWithPredicate:(NSPredicate *)searchFilter;

/**
 * 获取待发送和发送失败的数据数量
 */
+ (NSUInteger)fetchCountOfToBeSendEntities;

/**
 * 通过 searchFilter 获取数据数量
 */
+ (NSUInteger)fetchCountOfEntitiesWithPredicate:(NSPredicate *)searchFilter;

/**
 * 插入埋点数据
 * data 埋点参数
 * sendAPI 数据接收的服务器API
 * completion 插入数据库成功后的回调方法，在保存完成后调用的完成块。如果发生错误，块将以“BOOL”和“NSError”实例的形式传递成功状态。总是在主队列上调用。
 * 该方法调用完成，fetch方法获取相应的数据就可获取到，不需要等completion回调。
 */
+ (void)insertData:(NSDictionary *)data sendAPI:(NSString *)sendAPI;
+ (void)insertData:(NSDictionary *)data sendAPI:(NSString *)sendAPI completion:(MRSaveCompletionHandler)completion;

/**
* 修改埋点数据
* entities 需要修改的实体
* sendStatus 需要修改为的状态，
* completion 插入数据库成功后的回调方法，在保存完成后调用的完成块。如果发生错误，块将以“BOOL”和“NSError”实例的形式传递成功状态。总是在主队列上调用。
* 该方法调用完成，fetch方法获取相应的数据就可获取到，不需要等completion回调。
*/
+ (void)updateDataEntities:(NSArray<PhobosSendDataEntity *> *)entities sendStatus:(PhobosDataSendStatus)sendStatus;
+ (void)updateDataEntities:(NSArray<PhobosSendDataEntity *> *)entities sendStatus:(PhobosDataSendStatus)sendStatus completion:(MRSaveCompletionHandler)completion;

/**
 * 删除数据
 */
+ (void)deleteDataEntities:(NSArray<PhobosSendDataEntity *> *)entities;
+ (void)deleteAllEntities;

@end

NS_ASSUME_NONNULL_END
