//
//  PhobosPVProtocol.h
//  Pods
//
//  Created by wangyang on 2017/2/7.
//
//

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN
@protocol PhobosPVProtocol <NSObject>

typedef void(^PhobosUpdatePVBlock)(void);

/**
 *  @author 翟国钧, 16-02-24 17:02:22
 *
 *  @brief 埋点的时候，有些埋点都需要业务id，比如DoctorId，针对那些只能在父类中埋点的业务，要在子类中设置当前id，然后在父类中取到
 *  在一些详情页的分享和收藏的时候，由于分享、收藏的方法在basewebview里，所以，统一在里面做处理，但是需要在子类中把想要的参数传过去。包括：type（类型）、from（来自哪）、businessId（对应业务id）
 *  @since 5.9.1
 */
@property (nonatomic, copy, nonnull) NSString *businessId;

/**
 *  @author 翟国钧 in 16-02-25 19:02:32
 *
 *  埋点pv事件中当前页面的别名
 *  @since 5.9.1
 */
@property (nonatomic, copy, nonnull) NSString *pageName;

/**
 *  @author 翟国钧  in 16-02-25 19:02:32
 *
 *  @brief 获取前一个页面的pageName。
 *
 *  @since 5.9.1
 */
@property (nonatomic, copy, nonnull) NSString *referer;

/**
 当前VC.view 显示的时候的时间戳
 @author zhaiguojun 16-10-12 
 */
@property (nonatomic, copy, nonnull) NSString *inTime;

/// 当前VC.view 显示的时候的时间戳(精确到毫秒)
@property (nonatomic, copy, nonnull) NSString *inTimeMillis;

/**
 前一个页面的businessId。该属性有可能为空字符串
 */
@property (nonatomic, copy, nonnull) NSString *referrerId;

/**
 controller是否需要记录pv事件，默认为YES。
 controller作为childController时，需要设置childController.needLogPV = NO，以防止影响containerController的pv事件
 */
@property(nonatomic, assign) BOOL needLogPV;

/**
 需要额外添加参数
 */
@property (nonatomic, copy, nonnull) NSString *extraParam;

/**
 首页tab名称
 */
@property (nonatomic, copy) NSString *tabName;

/**
 获取上一个页面的tab名称
 */
@property (nonatomic, copy) NSString *referrerTabName;

/**
 is_push:判断是否是推送标识
 1: 是推送页面跳转
 0: 普通页面跳转
 */
@property (nonatomic, copy) NSString *isPush;

/**
 获取上一个页面链路的page_name link  by 7.20.0  如果有此页面有page_name则添加 ， 没有添加""
 */
@property (nonatomic, strong) NSArray *referrerLink;

/// 业务层更新PVStart信息
@property (nonatomic, copy) PhobosUpdatePVBlock updatePVStartBlock;
/// 业务层更新PVEnd信息
@property (nonatomic, copy) PhobosUpdatePVBlock updatePVEndBlock;

@end
NS_ASSUME_NONNULL_END
