//
//  PhobosUtil.h
//  Phobos工具类
//
//  Created by Thierry on 16/2/15.
//
//

#import <Foundation/Foundation.h>

typedef void (^SendDataSuccessBlock)(NSInteger code);


@interface PhobosUtil : NSObject

/**
 *  @brief 压缩待上传的数据。经过测试，50条数据压缩大概6毫秒，所以不要放在异步线程中处理
 *
 *  @param originData 压缩前的数据
 *
 *  @return 压缩后的数据
 *
 *  @since 0.0.1
 */
+ (NSData *)compressData:(NSData *)originData;

/**
 *  @brief 上传数据
 *
 *
 *  @since 0.0.1
 */
+ (void)sendData:(NSData *)data success:(SendDataSuccessBlock)success;

/**
 *  @brief 上传数据
 *
 *
 *  @7735 精准曝光
 */
+ (void)sendData:(NSData *)data currentAPI:(NSString *)currentAPI success:(SendDataSuccessBlock)success;
/**
 *  @brief 获取当前时间的秒数
 *  @since 0.0.1
 */
+ (NSString *)currentTime;
/**
 获取当前时间的毫秒数
 @return v7.14.0
 */
+ (NSString *)currentMMTime;

+ (NSString *)getAppVersion;
+ (BOOL)isNonEmpty:(NSString *)string;
+ (NSData *)encodeJSON:(id)obj;
//+ (NSString *)deviceId;
/** 获取手机型号 */
+ (NSString *)platform;
/**
 * 获取IP地址
 */
+ (NSString *)getIPAddress:(BOOL)preferIPv4;

/**
 * 获取cup指令集
 */
+ (NSString *)currentDeviceCPUType;

/***
 * CPU总数目
 **/
+ (NSString *)currentDeviceCPUCount;

/***
 * 网卡地址
 **/
+ (NSString *)getMacAddress;

/**
 * 获取运营商信息
 */
+ (NSString *)getTelephonyInfo;

/**
 * 内存大小，单位：兆
 */
+ (NSString *)getTotalMemorySize;

/**
 * 获取手机运行时间，从开机到现在
 */
+ (NSString *)deviceRunTime;


/**
 * MD5加密
 */
+ (NSString *)MD5String:(NSString *)str;

/*!
*  @author zhaiguojun, 16-04-21
*
*  @brief 把字典和数组转成string
*
*  相当于调用 [NSJSONSerialization dataWithJSONObject:object options:0 error:&error];
*  @return 转换后的string
*
*  @since 5.9.3
*/
+ (NSString *)convertToJsonString:(id)object;
@end
