//
//  GMButton.h
//  Gengmei
//
//  Created by Thierry on 12/26/14.
//  Copyright (c) 2014 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

//见设计稿(UI组件化->组件_按钮.sketch)
typedef NS_ENUM(NSUInteger, GMButtonType) {
    GMButtonTypeGreen,                              //绿色矩形(见左1)
    GMButtonTypeGreenRound,                         //绿色带6px的圆角矩形(见左2)
    GMButtonTypeGreenSemicircle,                    //绿色半圆矩形(见左3)
    GMButtonTypeGreenBorder,                        //绿色边框矩形，只有两种状态（正常、失效，见左4）
    GMButtonTypeRed,                                //红色矩形(见右1)
    GMButtonTypeRedRound,                           //红色色带6px的圆角矩形(见右2)
    GMButtonTypeRedSemicircle,                      //红色半圆矩形(见右3)
    GMButtonTypeRedBorder,                          //红色边框矩形，只有两种状态（正常、失效、见右4）
    GMButtonTypeGrayBorderSemicircle,               //灰色边框半圆矩形，只有两种状态（正常、失效、见右5）
};



@interface GMButton : UIButton

/**
 *  @author licong, 16-12-30 17:12:10
 *
 *  button高亮时的背景色
 *
 *  @since 5.8
 */


@property (nonatomic, readonly) UIColor *highlightBackgroundColor;

/**
 *  @author licong, 16-12-30 17:12:31
 *
 *  button在normal时候的背景色
 *
 *  @since 5.8
 */

@property (nonatomic, readonly) UIColor *normalBackgroundColor;

/**
 *  @author licong, 16-12-30 17:12:59
 *
 *  button 在选中状态时候的背景色
 *
 *  @since 5.8
 */
@property (nonatomic, readonly) UIColor *selectedBackgroundColor;


/**
 *  @author licong, 16-12-30 17:12:55
 *
 *  是否支持Button自适应热区,Apple人机交互指南建议，可点击控件的热区最好是44*44，默认是NO，不支持
 *
 *  @since 5.8
 */
@property (nonatomic, assign) BOOL enableAdaptive;


/**
 *  @author licong, 16-12-30 17:12:31
 *
 *  自适应热区宽，默认是 44
 *
 *  @since 5.8
 */
@property (nonatomic, assign) float adaptiveHotAreaWidth;


/**
 *  @author licong, 16-12-30 17:12:09
 *
 *  自适应热区高，默认是 44
 *
 *  @since 5.8
 */

@property (nonatomic, assign) float adaptiveHotAreaHeight;




/**
 *  @author licong, 16-12-30 17:12:30
 *
 *  初始化方法
 *
 *  @since 5.8
 */
- (void)setup __attribute__((objc_requires_super));


/**
 *  @author licong, 16-12-30 17:12:46
 *
 *  创建一个button，并设置好它的title、backgroundColor、size、titleColor
 *
 *  @param title      title
 *  @param bgColor    backgroundColor
 *  @param size       大小
 *  @param titleColor title标题
 *
 *  @return 返回创建好的button
 *
 *  @since 5.8
 */
+ (instancetype)buttonWithTitle:(nullable NSString *)title
                backgroundColor:(nullable UIColor *)bgColor
                  titleFontSize:(CGFloat)size
                     titleColor:(nullable UIColor *)titleColor;

/**
 *  @author licong
 *
 *  UI组件化后自定制Button
 *
 *  @param customType 工厂模式下的button类型
 *
 *  @return 返回创建好的button
 *
 *  @since 6.2.0
 */
+ (instancetype)buttonWithCustomType:(GMButtonType)customType;

/**
 *  @author licong, 16-12-30 17:12:29
 *
 *  根据Button的状态设置对应的背景颜色
 *
 *  @param backgroundColor button的背景颜色
 *  @param state           button的controlState
 *
 *  @since 5.8
 */
- (void)setBackgroundColor:(UIColor *)backgroundColor forState:(UIControlState)state;

@end

NS_ASSUME_NONNULL_END