//
//  GMImageView.m
//  Gengmei
//
//  Created by Thierry on 2/12/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMImageView.h"
#import <SDWebImage/UIImageView+WebCache.h>
#import "UIView+Layout.h"
#import "GMConstant.h"
#import "GMTheme.h"

@implementation GMImageView

- (void)makeRoundImage{
    
    CGFloat cornerRadius = MIN(self.width, self.height)/2;
    self.layer.cornerRadius = cornerRadius;
    self.layer.masksToBounds = YES;
    self.layer.borderWidth = 0.5;
    self.layer.borderColor = SEPARATOR_LINE_COLOR.CGColor;
}

- (void)setImageWithUrlString:(NSString *)urlString placeHolder:(NSString *)placeHolder{
    NSURL *url = [NSURL URLWithString:urlString];
    if (placeHolder!=nil && ![placeHolder isEqualToString:@""]) {
        [self setImage:[UIImage imageNamed:placeHolder]];
        [self sd_setImageWithURL:url placeholderImage:[UIImage imageNamed:placeHolder] completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
            if (cacheType==SDImageCacheTypeNone) {
                [GMImageView fadeInTransition:self];
            }
        }];
    }else{
        [self sd_setImageWithURL:url completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
            if (cacheType==SDImageCacheTypeNone) {
                [GMImageView fadeInTransition:self];
            }
        }];
    }
}

+ (void)fadeInTransition:(UIImageView *)view{
    CATransition *transtion = [CATransition animation];
    transtion.duration = 0.5;
    [transtion setTimingFunction:[CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut]];
    [transtion setType:kCATransitionFade];
    [transtion setSubtype:kCATransitionFromRight];
    [view.layer addAnimation:transtion forKey:@"transtionKey"];
}


@end
