//
//  GMLabel.h
//  Gengmei
//
//  Created by Thierry on 12/26/14.
//  Copyright (c) 2014 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface GMLabel : UILabel

typedef NS_ENUM(NSInteger, GMLabelVerticalAlignment){
    GMLabelVerticalAlignmentTop = 0, // 垂直方向顶部对齐
    GMLabelVerticalAlignmentMiddle,  // 垂直方向中间对齐
    GMLabelVerticalAlignmentBottom,  // 垂直方向底部对齐
};


/**
 *  @brief  垂直方向对齐。默认是 GMLabelVerticalAlignmentMiddle。因为有这个属性，所以需要重写 drawTextInRect
 */
@property (nonatomic,assign) GMLabelVerticalAlignment verticalAlignment;

/**
 *  @brief  文字与label边框的padding。因为有这个方法，所以重写了 intrinsicContentSize
 */
@property (nonatomic, assign) UIEdgeInsets paddingEdge;

/**
 *  @author licong, 16-12-30 17:12:50
 *
 *  创建一个UILabel
 *
 *  @param TextColor 色值
 *  @param fontSize  font大小
 *
 *  @return 一个新的UILabel
 *
 *  @since 5.8
 */
+ (GMLabel *)labelWithTextColor:(UIColor *)color fontSize:(CGFloat)fontSize;

/**
 *  @brief  创建一个UILabel
 *
 *  @param textAlignment        对齐方式
 *  @param backgroundColor      背景颜色
 *  @param textColor            文字颜色
 *  @param fontSize             字号
 */
+ (GMLabel *)labelWithTextAlignment:(NSTextAlignment)textAlignment backgroundColor:(UIColor*)backgroundColor textColor:(UIColor*)textColor fontSize:(CGFloat )fontSize;

/**
 *  @brief  设置label属性
 *
 *  @param textAlignment        对齐方式
 *  @param backgroundColor      背景颜色
 *  @param textColor            文字颜色
 *  @param fontSize             字号
 */
- (void)setTextAlignment:(NSTextAlignment)textAlignment backgroundColor:(UIColor*)backgroundColor textColor:(UIColor*)textColor  fontSize:(CGFloat )fontSize;

@end
