//
//  GMLoadingView.m
//  loadingAnimation
//
//  Created by wangyang on 12/23/14.
//  Copyright (c) 2014 WY. All rights reserved.
//

#import "GMLoadingView.h"

@interface GMLoadingView ()

@property (nonatomic, strong) UIImageView *foregroundImageView;
@end

@implementation GMLoadingView
+ (instancetype)loadingViewWithType:(GMLoadingViewType)type
{
    UIImage *backImage;
    UIImage *foreImage;
    
    if (type == GMLoadingViewTypeGreenLarge) {
        backImage = [UIImage imageNamed:@"loaing2_diceng"];
        foreImage = [UIImage imageNamed:@"loaing2"];
    }else if (type == GMLoadingViewTypeGray){
        backImage = [UIImage imageNamed:@"loaing1_diceng"];
        foreImage = [UIImage imageNamed:@"loaing1"];
    }else if (type == GMLoadingViewTypeGreenSmall){
        backImage = nil;
        foreImage = [UIImage imageNamed:@"GreenLoaingSmall"];
    }else{
        backImage = nil;
        foreImage = [UIImage imageNamed:@"GreenLoaingSmall"];
    }
    
    // 背景
    UIImageView *backgroundImageView = [[UIImageView alloc] initWithImage:backImage];
    
    // 前景
    UIImageView *foregroundImageView = [[UIImageView alloc] initWithImage:foreImage];
    
    GMLoadingView *view = [[GMLoadingView alloc] initWithFrame:foregroundImageView.bounds];
    view.backgroundColor = [UIColor clearColor];
    [view addSubview:backgroundImageView];
    [view addSubview:foregroundImageView];
    view.foregroundImageView = foregroundImageView;
    
    return view;
    
}


- (void)begingAnimation
{
    CABasicAnimation* animation = [CABasicAnimation animationWithKeyPath:@"transform.rotation.z"];
    animation.fromValue = @0.0f;
    animation.toValue = @(2*M_PI);
    animation.duration = .8f;             // this might be too fast
    animation.repeatCount = HUGE_VALF;     // HUGE_VALF is defined in math.h so import it
    [_foregroundImageView.layer addAnimation:animation forKey:@"rotation"];
}
- (void)endAnimation
{
    [_foregroundImageView.layer removeAllAnimations];
}
@end
