//
//  GMMarkStarView.h
//  ZhengXing
//
//  Created by Tulipa on 14-8-21.
//  Copyright (c) 2014年 Wanmei Creative. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSInteger, GMStarUserType) {
    GMStarUserTypeEdit   = 0,//可编辑，显示大星星
    GMStarUserTypeShow   = 1,//纯展示，显示小星星
    GMStarUserTypesSmallShow
};

typedef NS_ENUM(NSInteger, GMStarColor) {
    GMStarColorYellow   = 0,
    GMStarColorRed      = 1,
    GMStarColorSmallYellow
};

@interface GMMarkStarView : UIView


/* 可控的星星间距 */
@property (nonatomic, assign) NSInteger space;

@property (nonatomic, assign) GMStarColor starColor;

@property (nonatomic, assign) NSInteger mark;

/* 从5.7开始支持半颗星 */
@property (nonatomic, assign) float number;

/* 如果用作可以编辑个数的星星，就用大星星，纯展示的就用小星星 */
@property (nonatomic , assign) GMStarUserType type;

@property (nonatomic, copy) void(^markChange)(NSInteger mark);

- (id)initWithUseType:(GMStarUserType)type;

@end
