//
//  GMMarkStarView.m
//  ZhengXing
//
//  Created by Tulipa on 14-8-21.
//  Copyright (c) 2014年 Wanmei Creative. All rights reserved.
//

#import "GMMarkStarView.h"
#import "UIView+Layout.h"

@interface GMMarkStarView ()

@end

@implementation GMMarkStarView{
    NSMutableArray *buttons;
}

- (id)initWithUseType:(GMStarUserType)type
{
    _type = type;
    self = [self init];
    return self;
}

- (id)init{
    self = [super init];
    if (self){
        buttons = [[NSMutableArray alloc] initWithCapacity:5];
        for (int i = 1; i < 6; i ++){
            UIButton *button = [self createButton];
            [self addSubview:button];
            [buttons addObject:button];
            button.tag = i;
        }
    }
    return self;
}

- (UIButton *)createButton{
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button addTarget:self action:@selector(buttonClicked:) forControlEvents:UIControlEventTouchUpInside];
    
    UIImage *normalImage;
    UIImage *editImage;
    UIImage *hightlighImage;
    if (_type == GMStarUserTypeEdit) {//用大星星
        normalImage = [UIImage imageNamed:@"star_normal"];
        editImage   = [UIImage imageNamed:@"star_light_new"];
        hightlighImage = [UIImage imageNamed:@"star_light_new"];

    }else if (_type == GMStarUserTypeShow){//用小星星
        normalImage = [UIImage imageNamed:@"star_normal_small_red"];
        editImage   = [UIImage imageNamed:@"star_light_new_small_red"];
        hightlighImage = [UIImage imageNamed:@"star_half_red"];

    }else if (_type == GMStarUserTypesSmallShow) {
        normalImage = [UIImage imageNamed:@"show_small_gray_star"];
        editImage   = [UIImage imageNamed:@"show_small_star"];
        hightlighImage = [UIImage imageNamed:@"show_small_half_star"];

    }
    
    [button setImage:editImage forState:UIControlStateSelected];
    [button setImage:hightlighImage forState:UIControlStateHighlighted];
    [button setImage:normalImage forState:UIControlStateNormal];
    button.size = CGSizeMake(18, 18);
    if (_type == GMStarUserTypesSmallShow) {
        button.size = CGSizeMake(12, 12);
    }
    return button;
}

- (void)buttonClicked:(UIButton *)button{
    NSInteger tag = button.tag;
    self.mark = tag;
    if (self.markChange){
        self.markChange(tag);
    }
}


- (void)setMark:(NSInteger)tag{
    _mark = tag;
    [buttons enumerateObjectsUsingBlock:^(UIButton *btn, NSUInteger idx, BOOL *stop) {
        [btn setSelected:btn.tag <= tag];
        [btn setHighlighted:NO];
    }];
}

/* 通过向上、向下取整，获取到哪个位置应该显示半颗星 */
- (void)setNumber:(float)number
{
    _number = number;
    float big = ceilf(number);
    float small = floorf(number);
    [buttons enumerateObjectsUsingBlock:^(UIButton *btn, NSUInteger idx, BOOL *stop) {
        if (big != small) {
            if (idx+1<=small) {
                [btn setSelected:YES];
                [btn setHighlighted:NO];

            }else if(idx+1 == big){
                [btn setSelected:NO];
                [btn setHighlighted:YES];
            }else{
                [btn setSelected:NO];
                [btn setHighlighted:NO];

            }
        }else{
            [btn setSelected:btn.tag <= number];
            [btn setHighlighted:NO];

        }
    }];
}

- (void)layoutSubviews{
    [super layoutSubviews];
    
    UIView *view = buttons[0];
    CGFloat space = self.space==0?16:self.space;
    CGFloat insert = space + view.width;
    __weak __typeof(self)weakSelf = self;
    [buttons enumerateObjectsUsingBlock:^(UIButton *btn, NSUInteger idx, BOOL *stop) {
        [btn setLeft:(insert * idx)+ 10];
        [btn setCenterY:weakSelf.height / 2.0f];
    }];
}

@end
