//
//  PreviewCell.h
//  Gengmei
//
//  Created by Sean Lee on 4/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <SDWebImage/UIButton+WebCache.h>
#import "GMButton.h"
#import "GMLabel.h"

@class GMPreviewCell;

@protocol GMPreviewCellDelegate<NSObject>

@optional
- (void)prepareRetryUploadPreviewCell:(GMPreviewCell *)cell;

- (void)prepareAddPreviewCell:(GMPreviewCell *)cell;

- (void)prepareDeletePreviewCell:(GMPreviewCell *)cell;

- (void)didSelectedPreviewCell:(GMPreviewCell *)cell;

@end


@interface GMPreviewCell : UIButton
@property (nonatomic,assign) NSInteger index;
@property (nonatomic,strong) GMButton *deleteButton;
@property (nonatomic,strong) UIImage  *image;
@property (nonatomic,strong) GMButton *retryButton;
@property (nonatomic,strong) GMLabel  *dayLabel;


@property (nonatomic,strong) UIActivityIndicatorView *indicatorView;
@property (nonatomic, assign) id<GMPreviewCellDelegate>delegate;


- (id)initWithFrame:(CGRect)frame image:(UIImage *)image;

- (void)setButtonImageWithUrl:(NSString *)url forState:(UIControlState)state completed:(SDWebImageCompletionBlock)completedBlock;
@end
