//
//  GMBaseTableViewCell.h
//  Gengmei
//
//  Created by 翟国钧 on 15/1/14.
//  Copyright (c) 2015年 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface GMTableViewCell : UITableViewCell{
    
    UIImageView *_detailDisclosure;
}
@property (nonatomic, strong) UIImageView *detailDisclosure;
/** @brief Cell统一下边框。不需要时需要隐藏 */
@property (nonatomic , strong) UIView *bottomLine;

/**
 *  @brief  代替 UITableViewCellAccessoryDetailDisclosureButton，默认 NO，不显示。控制的是 _detailDisclosure。
 */
@property (nonatomic, assign) BOOL showArrow;

/**
 *  @brief  重写的起点。如果想在cell里添加息定义的view，或者改变bottomLine，从这里开始。
 *  必须调用super
 */
- (void)setup __attribute__((objc_requires_super));


#pragma mark - Autolayout

/**
 *  @author wangyang, 15-11-02 11:11:48
 *
 *  @brief  在 lifeCycle 里调用。里面为固定不变的约束
 *  @since 5.4.0
 */
- (void)cellConstraints;

/**
 *  @author wangyang, 15-11-02 11:11:48
 *
 *  @brief  在 lifeCycle 里调用。需要变化的约束写在这里
 *  @since 5.4.0
 */
- (void)updateCellConstraints;
@end
