//
//  WYSegmentView.h
//  GengMei
//
//  Created by wangyang on 13-8-9.
//  Copyright (c) 2015 Gengmei. All rights reserved.
//

#import "WYSegmentView.h"
#import <QuartzCore/QuartzCore.h>
#import "Masonry.h"
#import "UIView+Layout.h"
#import "GMConstant.h"
#import "UIView+LineWithAutolayout.h"
#import "GMFont.h"
#import "GMTheme.h"

#define BUTTON_TAG      1010

@interface WYSegmentView ()
{
    UIView *_indicatorView;
    UIView *_container;
}
@property (nonatomic, assign) NSInteger selectedSegmentIndex;

@end


@implementation WYSegmentView


- (void)setup
{
    [super setup];

    _bottomLine = [self addBottomLine];

    // scroll view
    _scrollView = [UIScrollView new];
    [self addSubview:_scrollView];
    [_scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.insets(UIEdgeInsetsZero);
    }];

    // container
    _container = [UIView new];
    [_scrollView addSubview:_container];
    [_container mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.insets(UIEdgeInsetsZero);
    }];

    // 属性初始化
    _scrollView.showsHorizontalScrollIndicator = NO;
    _scrollView.scrollsToTop = NO;
    self.innerSpace = 0;
    self.indicatorHorizonalPadding = 7.5 * ONE_PIXEL;
    self.titleTextAttributes = @{NSFontAttributeName : GMFont(14),
                                      NSForegroundColorAttributeName : [UIColor whiteColor]};
    self.selectedTitleTextAttributes = @{NSFontAttributeName : GMFont(14),
                                 NSForegroundColorAttributeName : [UIColor greenColor]};
    self.showIndicator = NO;
    self.indicatorColor = MAIN_VISUAL_COLOR;
    self.widthStyle = WYSegmentViewWidthStyleDynamic;
    _selectedSegmentIndex = 0;

    // 添加指示器
    [self setupIndicatorView];
}

- (void)setupIndicatorView {

    _indicatorView = [UIView new];
    _indicatorView.backgroundColor = self.indicatorColor;
    [_scrollView insertSubview:_indicatorView atIndex:0];

    __weak __typeof(self)weakSelf = self;
    self.customIndicatorConstraint = ^(UIView *indicator, UIButton *button) {
        // 在 _sectionTitles 还没有数据时，button 并没有被添加，会是 nil, 所以添加如下判断
        if (button == nil || indicator == nil) {
            return;
        }
        // 改变indicator
        [indicator mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(0);
            make.width.equalTo(button.titleLabel.mas_width).offset(weakSelf.indicatorHorizonalPadding);
            make.centerX.equalTo(button);
            make.height.mas_equalTo(2);//和设计沟通这里要的是2pt不是2px
        }];
    };
}

- (void)setupSegments {
    UIView *preView;
    [_container removeAllSubviews];
    for (int i = 0; i < _sectionTitles.count; i++) {

        UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
        button.tag = i + BUTTON_TAG;
        [button addTarget:self action:@selector(buttonClick:) forControlEvents:UIControlEventTouchUpInside];

        // 标题
        NSString *title = _sectionTitles[i];
        NSAttributedString *attriTitle = [[NSAttributedString alloc] initWithString:title attributes:self.titleTextAttributes];
        [button setAttributedTitle:attriTitle forState:UIControlStateNormal];
        NSAttributedString *seletedAttriTitle = [[NSAttributedString alloc] initWithString:title attributes:self.selectedTitleTextAttributes];
        [button setAttributedTitle:seletedAttriTitle forState:UIControlStateSelected];

        // 约束
        [_container addSubview:button];

        // 每个button的约束。这里考虑了可能设置 self.contentInset的情况
        CGSize titleSize = [attriTitle size];
        [button mas_makeConstraints:^(MASConstraintMaker *make) {
            if (i == 0) {
                make.left.mas_equalTo(0);
            }else{
                make.left.equalTo(preView.mas_right).offset(self.innerSpace);
            }
            make.top.equalTo(_container).offset(_scrollView.contentInset.top);
            make.bottom.equalTo(_container).offset(-_scrollView.contentInset.bottom);
            make.height.equalTo(_scrollView).offset(-_scrollView.contentInset.top - _scrollView.contentInset.bottom);

            if (self.widthStyle == WYSegmentViewWidthStyleDynamic) {
                make.width.mas_equalTo(ceilf(titleSize.width + _itemHorizonalPadding * 2));
            }else {
                make.width.equalTo(_scrollView).multipliedBy(1.0/_sectionTitles.count).offset(0);

            }

            if (i == _sectionTitles.count-1) {
                make.right.mas_equalTo(0);
            }
        }];

        if (self.customButtonUI) {
            self.customButtonUI(button);
        }

        preView = button;
    }
}
#pragma mark - Setter
/**
 *	清除原来的 button，并依据 title array 重新添加 button
 *
 *	@param	buttonTitleArray	待显示的 title array
 */
- (void)setSectionTitles:(NSArray *)sectionTitles
{
    if (sectionTitles.count == 0) {
        return;
    }

    _sectionTitles = sectionTitles;
    [_container.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
}

- (void)setShowIndicator:(BOOL)showIndicator {
    _showIndicator = showIndicator;
    _indicatorView.hidden = !_showIndicator;
}

- (void)setIndicatorColor:(UIColor *)indicatorColor {
    _indicatorColor = indicatorColor;
    _indicatorView.backgroundColor = _indicatorColor;
}

#pragma mark - Layout Views

- (void)layoutSegments
{
    [self setupSegments];
    [self setSelectedSegmentIndex:_selectedSegmentIndex animated:NO];
}

#pragma mark - Animation

- (void)animateSelectedButtonBackgroundAtIndex:(NSUInteger)index animate:(BOOL)animate
{
    // 将 _indicatorView 移动到相应 button 位置
    UIButton *currentButton = (UIButton *)[_container viewWithTag:index + BUTTON_TAG];

    // 改变indicator的坐标
    if (self.customIndicatorConstraint) {
        self.customIndicatorConstraint(_indicatorView, currentButton);
    }

    [UIView animateWithDuration:(animate ? 0.25 : 0.0) animations:^{
        [self layoutIfNeeded];

        // 改变offset
        // 当rect的中心点大于scrollview的中心点，那就可以把这个button往中间移一下
        if (CGRectGetMidX(currentButton.frame) > self.width / 2) {

            // 下面这个算法是基于offset为0的情况
            CGFloat offset = CGRectGetMidX(currentButton.frame) - self.width / 2;
            CGFloat maxOffset = _scrollView.contentSize.width - self.width + _scrollView.contentInset.right;
            if (offset > maxOffset) {
                offset = maxOffset;
            }
            _scrollView.contentOffset = CGPointMake(offset, 0);
        }else {
            _scrollView.contentOffset = CGPointMake(-_scrollView.contentInset.left, 0);
        }
    }];
}


- (void)setSelectedSegmentIndex:(NSInteger)selectedSegmentIndex animated:(BOOL)animated {
    // 通过使用 selectedIndex 的 set 方法来执行button选择状态的 UI 变化，详见其 set 方法
    [self changeStatusForePreButton:self.selectedSegmentIndex newButton:selectedSegmentIndex];
    
    // 改变属性值
    _selectedSegmentIndex = selectedSegmentIndex;

    // 调用动画
    [self animateSelectedButtonBackgroundAtIndex:selectedSegmentIndex animate:animated];
}

- (void)changeStatusForePreButton:(NSInteger)preButtonIndex newButton:(NSInteger)newButtonIndex{
    
    // 取消先前 button 的状态
    UIButton *previousbutton = (UIButton *)[_container viewWithTag:preButtonIndex + BUTTON_TAG];
    previousbutton.selected = NO;
    
    // 处理新的 button
    UIButton *currentButton = (UIButton *)[_container viewWithTag:newButtonIndex + BUTTON_TAG];
    currentButton.selected = YES;
    
    // 立即变更button状态，以防之后的动画影响button title的改变
    [self layoutIfNeeded];
}


#pragma mark - Action
- (void)buttonClick:(UIButton *)button
{
    [self setSelectedSegmentIndex:button.tag - BUTTON_TAG animated:YES];
    
    if (_didSelectedBlock) {
        _didSelectedBlock(self.selectedSegmentIndex);
    }
}

@end
