//
//  UIResponder+PhobosPV.m
//  Pods
//
//  Created by wangyang on 2017/2/7.
//
//

#import "UIResponder+PhobosPV.h"
#import <objc/runtime.h>
#import "PhobosUtil.h"

@implementation UIResponder (PhobosPV)

/**
 *  @author 翟国钧, 16-03-01 15:03:24
 *
 *  @brief 取当前导航栈中当前VC的上级VC，如果该VC存在，就获取他的pageName
 *
 *  @since 5.9.1
 */
- (void)initReferer {
    // 只有不为空，且是controller的情况下才自动获取
    if ([self.referer isEqualToString:@""] && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            // app全局只有一个navigation，发现此时用navigation.topViewController presentViewController时，最终使用的是navigation弹出的
            // 所以此处要判断，如果是navigation弹出，最后还是要定位到topViewController
            if ([me.presentingViewController isKindOfClass:[UINavigationController class]]) {
                UIViewController *top = ((UINavigationController *)me.presentingViewController).topViewController;
                objc_setAssociatedObject(self, @selector(referer), top.pageName, OBJC_ASSOCIATION_COPY);
            } else {
                objc_setAssociatedObject(self, @selector(referer), me.presentingViewController.pageName, OBJC_ASSOCIATION_COPY);
            }
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIndex = navigationPool.count - 2;
            if (refererIndex < 0 ) {
                return ;
            }
            UIViewController *controller = navigationPool[refererIndex];
            objc_setAssociatedObject(self, @selector(referer), controller.pageName, OBJC_ASSOCIATION_COPY);
        }
    }
}

/**
 此方法在onPvStart时调用，给referrerTabName赋值
 */
- (void)initReferrerTabName {
    // 只有是controller的情况下才自动获取
    if ([self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            // app全局只有一个navigation，发现此时用navigation.topViewController presentViewController时，最终使用的是navigation弹出的
            // 所以此处要判断，如果是navigation弹出，最后还是要定位到topViewController
            if ([me.presentingViewController isKindOfClass:[UINavigationController class]]) {
                UIViewController *top = ((UINavigationController *)me.presentingViewController).topViewController;
                objc_setAssociatedObject(self, @selector(referrerTabName), top.tabName, OBJC_ASSOCIATION_COPY);
            } else {
                objc_setAssociatedObject(self, @selector(referrerTabName), me.presentingViewController.tabName, OBJC_ASSOCIATION_COPY);
            }
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIndex = navigationPool.count - 2;
            if (refererIndex < 0 ) {
                return ;
            }
            UIViewController *controller = navigationPool[refererIndex];
            objc_setAssociatedObject(self, @selector(referrerTabName), controller.tabName, OBJC_ASSOCIATION_COPY);
        }
    }
}

- (void)setReferer:(NSString *)referer {
    objc_setAssociatedObject(self, @selector(referer), referer, OBJC_ASSOCIATION_COPY);
}

- (NSString *)referer
{
    NSString *referer = objc_getAssociatedObject(self, @selector(referer));
    return referer == nil ? @"" : referer;
}

- (NSString *)pageName {
    NSString *name = objc_getAssociatedObject(self, @selector(pageName));
    return name == nil ? @"" : name;
}

- (void)setPageName:(NSString *)pageName {
    objc_setAssociatedObject(self, @selector(pageName), pageName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)businessId {
    NSString *businessId = objc_getAssociatedObject(self, @selector(businessId));
    return businessId == nil ? @"" : businessId;
}

- (void)setBusinessId:(NSString *)businessId {
    objc_setAssociatedObject(self, @selector(businessId), businessId, OBJC_ASSOCIATION_COPY);
}

- (void)setInTime:(NSString *)inTime {
    objc_setAssociatedObject(self, @selector(inTime), inTime, OBJC_ASSOCIATION_COPY);
}


/**
 这个地方inTime的值为nil的情况不做考虑,因为Phobos不会发送。inTime必须在controller viewWillAppear时赋值
 */
- (NSString *)inTime {
    NSString *inTime = objc_getAssociatedObject(self, @selector(inTime));
    return inTime;
}

- (void)initReferrerIdIfNil {
     // 只有不为空，且是controller的情况下才自动获取
    if ([self.referrerId isEqualToString:@""] && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            objc_setAssociatedObject(self, @selector(referrerId), me.presentingViewController.businessId, OBJC_ASSOCIATION_COPY);
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIdIndex = navigationPool.count - 2;
            if (refererIdIndex < 0) {
                objc_setAssociatedObject(self, @selector(referrerId), @"", OBJC_ASSOCIATION_COPY);
            } else {
                UIViewController *controller = navigationPool[refererIdIndex];
                NSString *preBusinessId = controller.businessId;
                objc_setAssociatedObject(self, @selector(referrerId), preBusinessId, OBJC_ASSOCIATION_COPY);
            }
        }
    }
}

- (void)setReferrerId:(NSString *)referrerId {
    objc_setAssociatedObject(self, @selector(referrerId), referrerId, OBJC_ASSOCIATION_COPY);
}

- (NSString *)referrerId {
    NSString *referrerId = objc_getAssociatedObject(self, @selector(referrerId));
    return referrerId == nil ? @"" : referrerId;
}

- (BOOL)needLogPV {
    NSNumber *needLogPV = objc_getAssociatedObject(self, @selector(needLogPV));
    return needLogPV == nil ? YES : needLogPV.boolValue;
}

- (void)setNeedLogPV:(BOOL)needLogPV {
    objc_setAssociatedObject(self, @selector(needLogPV), @(needLogPV), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (void)setExtraParam:(NSString *)extraParam {
    objc_setAssociatedObject(self, @selector(extraParam), extraParam, OBJC_ASSOCIATION_COPY);
}

- (NSString *)extraParam {
    NSString *extraParam = objc_getAssociatedObject(self, @selector(extraParam));
    return extraParam == nil ? @"" : extraParam;
}

- (void)setTabName:(NSString *)tabName {
    objc_setAssociatedObject(self, @selector(tabName), tabName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)tabName {
    NSString *tabName = objc_getAssociatedObject(self, @selector(tabName));
    return tabName == nil ? @"" : tabName;
}

- (void)setReferrerTabName:(NSString *)referrerTabName {
    objc_setAssociatedObject(self, @selector(referrerTabName), referrerTabName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)referrerTabName {
    NSString *referrerTabName = objc_getAssociatedObject(self, @selector(referrerTabName));
    return referrerTabName == nil ? @"" : referrerTabName;
}

- (void)setIsPush:(NSString *)isPush {
    objc_setAssociatedObject(self, @selector(isPush), isPush, OBJC_ASSOCIATION_COPY);
}

- (NSString *)isPush {
    NSString *isPush = objc_getAssociatedObject(self, @selector(isPush));
    return isPush == nil ? @"" : isPush;
}

@end
