//
//  GMDataCompressorTest.m
//  GMPhobos
//
//  Created by Thierry on 16/2/15.
//  Copyright © 2016年 licong. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "PhobosUtil.h"

@interface GMPhobosUtilTest : XCTestCase
@property (nonatomic, retain) NSMutableArray *mockArray;
@end

@implementation GMPhobosUtilTest

- (void)setUp {
    [super setUp];
    _mockArray = [[NSMutableArray alloc] init];
    for (int i=0; i<50; i++) {
        [_mockArray addObject:@{@"app":@{@"channel":@"App Store",@"name":@"gengmei_doctor",@"version":@"1.8.0"},
                                @"created_at":@"1455529180",
                                @"device":@{@"device_id":@"E8E13EB6-030A-40A0-A55A-70E7CE288740",@"device_type":@"ios"},
                                @"params":@{@"tab_id":@"diary"},
                                @"type":@"home_click_tab",
                                @"user_id": @0,
                                @"version": @110
                                }];
    }
    // Put setup code here. This method is called before the invocation of each test method in the class.
}

- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
}

/**
 *  @brief 测试50条数据压缩速度
 *
 *  @description 经过测试50条数据压缩大约1毫秒左右，几乎不耗时
 *
 *  @since 0.0.7
 */
- (void)testDataCompressPerformance {
    [self measureBlock:^{
        [self encodeAndCompressArray:_mockArray];
    }];
}


/**
 *  @brief 发送数据测试
 *
 *  @since 0.0.7
 */
- (void)testSendDataToMars{
    XCTestExpectation *expectation = [self expectationWithDescription:@"Testing Async Method Works!"];
    
    NSData *mockData = [self encodeAndCompressArray:_mockArray];
    [PhobosUtil sendData:mockData success:^(NSInteger code) {
        [expectation fulfill];
        XCTAssertEqual(code, 200);
    }];
    
    //如果超时，则认为发送失败
    [self waitForExpectationsWithTimeout:3 handler:^(NSError *error) {
        if(error)
        {
            XCTFail(@"Expectation Failed with error: %@", error);
        }
    }];
}

- (NSData *)encodeAndCompressArray:(id)obj {
    NSData *data = [NSJSONSerialization dataWithJSONObject:obj options:0 error:nil];
    NSData *compressedData = [PhobosUtil compressData:data];
    return compressedData;
}

- (void)testDeviceId {
    NSString *result = [PhobosUtil deviceId];
    XCTAssertTrue(result.length > 0, "PhobosUtil deviceId方法返回不正确");
}

@end
