//
//  UIViewController+KeyboardAnimation.m
//  yingshibaokaoyan
//
//  Created by wangyang on 7/17/14.
//  Copyright (c) 2014 com.zkyj.yingshibao.kaoyao. All rights reserved.
//

#import "NSObject+KeyboardAnimation.h"
#import <objc/runtime.h>

static const char kwy_targetView;
static const char kwy_showAnimationblock;
static const char kwy_hideAnimationblock;

@interface NSObject ()
@property (nonatomic, strong) UIView *wy_targetView;
@property (nonatomic, copy) ShowKeyboardAnimation wy_showAnimationblock;
@property (nonatomic, copy) HideKeyboardAnimation wy_hideAnimationblock;
@end

@implementation NSObject (KeyboardAnimation)



#pragma mark - 属性get、set


- (ShowKeyboardAnimation)wy_showAnimationblock
{
    return objc_getAssociatedObject(self, &kwy_showAnimationblock);
}

- (void)setWy_showAnimationblock:(ShowKeyboardAnimation)wy_showAnimationblock
{
    objc_setAssociatedObject(self, &kwy_showAnimationblock, wy_showAnimationblock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (HideKeyboardAnimation)wy_hideAnimationblock
{
    return objc_getAssociatedObject(self, &kwy_hideAnimationblock);
}

- (void)setWy_hideAnimationblock:(HideKeyboardAnimation)wy_hideAnimationblock
{
    objc_setAssociatedObject(self, &kwy_hideAnimationblock, wy_hideAnimationblock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}


- (UIView *)wy_targetView
{
    return objc_getAssociatedObject(self, &kwy_targetView);
}
- (void)setWy_targetView:(UIView *)wy_targetView
{
    objc_setAssociatedObject(self, &kwy_targetView, wy_targetView, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


#pragma mark - 监听

- (void)observeKeyboardForView:(UIView *)view showKeyboardAnimation:(ShowKeyboardAnimation)animation1 hideKeyboardAnimation:(HideKeyboardAnimation)animation2
{
    self.wy_showAnimationblock = animation1;
    self.wy_targetView = view;
    self.wy_hideAnimationblock = animation2;
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShow:)
                                                 name:UIKeyboardWillShowNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillHide:)
                                                 name:UIKeyboardWillHideNotification
                                               object:nil];
}

- (void)removeObservKeyboard
{
    self.wy_showAnimationblock = nil;
    self.wy_targetView = nil;
    self.wy_hideAnimationblock = nil;
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillShowNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillHideNotification object:nil];
}


#pragma mark - 监听响应
- (void)keyboardWillShow:(NSNotification *)note{
    // get keyboard size and loctaion
	CGRect keyboardFrame;
    [[note.userInfo valueForKey:UIKeyboardFrameEndUserInfoKey] getValue: &keyboardFrame];
    // Need to translate the bounds to account for rotation.
    keyboardFrame = [[UIApplication sharedApplication].keyWindow convertRect:keyboardFrame toView:self.wy_targetView.superview];
    
    NSNumber *duration = [note.userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey];
    NSNumber *curve = [note.userInfo objectForKey:UIKeyboardAnimationCurveUserInfoKey];
    self.wy_showAnimationblock(keyboardFrame, [duration doubleValue], [curve integerValue], note);
}

- (void)keyboardWillHide:(NSNotification *)note{
    
    NSNumber *duration = [note.userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey];
    NSNumber *curve = [note.userInfo objectForKey:UIKeyboardAnimationCurveUserInfoKey];
    
    self.wy_hideAnimationblock([duration doubleValue], [curve integerValue], note);
}
@end
