//
//  UIImage+GM.m
//  Gengmei
//
//  Created by licong on 15/12/29. Rewrite by wangyang on 2016-7-4
//  Copyright © 2016年 Wanmeichuangyi. All rights reserved.
//

#import "UIImage+GM.h"

@implementation UIImage (GM)
#pragma mark - 从颜色生成图片
+ (UIImage *)imageWithColor:(UIColor *)color {
    CGRect rect = CGRectMake(0.0f, 0.0f, 1.0f, 1.0f);
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextSetFillColorWithColor(context, [color CGColor]);
    CGContextFillRect(context, rect);
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}


#pragma mark - 改变大小
- (UIImage *)resizedImageWithSize:(CGSize)size {
    UIGraphicsBeginImageContext(size);
    CGRect rect = CGRectMake(0, 0, size.width, size.height);
    // CGContextDrawImage时需要额外考虑UIImage.imageOrientation，drawInRect可以自动帮我们做好这件事
    [self drawInRect:rect];
    // 另外，我们不需要指定使用 CGContextSetInterpolationQuality，使用默认值Hight就可以。参考http://stackoverflow.com/questions/5685884/imagequality-with-cgcontextsetinterpolationquality
    UIImage *newImg = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return newImg;
}

#pragma mark - 旋转
- (UIImage *)rotatedWithAngle:(double)angle
{
    CGAffineTransform transform = CGAffineTransformMakeRotation(angle * M_PI / 180);
    return [self rotatedWithTransform:transform];
}

- (UIImage *)rotatedWithTransform:(CGAffineTransform)transform {
    // 旋转后图片的大小
    CGRect rotatedRect = CGRectApplyAffineTransform(CGRectMake(0, 0, self.size.width, self.size.height), transform);
    rotatedRect.origin.x = 0;
    rotatedRect.origin.y = 0;
    CGSize rotatedSize = rotatedRect.size;

    UIGraphicsBeginImageContextWithOptions(rotatedSize, YES, self.scale);
    CGContextRef bitmap = UIGraphicsGetCurrentContext();

    // 将 origin 图片的移动中间， 这样我们就可以绕着中心点旋转
    CGContextTranslateCTM(bitmap, rotatedSize.width / 2, rotatedSize.height / 2);

    // 旋转画布布
    CGContextConcatCTM(bitmap, transform);

    // 再将 origin 移回来
    CGContextTranslateCTM(bitmap, rotatedSize.width / -2, rotatedSize.height / -2);

    // drawInRect 会考虑图片的 orientation，也会考虑当前Context的变换
    [self drawInRect:rotatedRect];
    UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return newImage;
}


#pragma mark - 剪切
- (UIImage *)imageWithCropRect:(CGRect)rect
{
    CGImageRef croppedImage = CGImageCreateWithImageInRect(self.CGImage, rect);
    UIImage *image = [UIImage imageWithCGImage:croppedImage];
    CGImageRelease(croppedImage);
    return image;
}
@end
