//
//  UIView+LineWithAutolayout.m
//  ZhengXing
//
//  Created by wangyang on 11/6/14.
//  Copyright (c) 2014 Wanmei Creative. All rights reserved.
//

#import "UIView+LineWithAutolayout.h"
#import <Masonry/Masonry.h>
#import "GMConstant.h"
#import "GMTheme.h"

@interface OnePixelLine : UIView

@end

@implementation OnePixelLine
@end

@implementation UIView (LineWithAutolayout)

- (UIView *)addLineWithoutFrame{
    UIView *line = [OnePixelLine new];
    line.backgroundColor = SEPARATOR_LINE_COLOR;
    [self addSubview:line];
    return line;
}

- (UIView *)addTopLine
{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.height.offset(ONE_PIXEL);
    }];
    return line;
}

- (UIView *)addBottomLine
{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(0);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.height.offset(ONE_PIXEL);
    }];
    
    return line;
}

- (UIView *)addCenterHorizontalLineWithLeft:(CGFloat)left right:(CGFloat)right{
    
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(left);
        make.right.mas_equalTo(right);
        make.height.offset(ONE_PIXEL);
    }];
    
    return line;
}

- (UIView *)addCenterVerticalLineWithTop:(CGFloat)top bottom:(CGFloat)bottom{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(top);
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(bottom);
        make.width.offset(ONE_PIXEL);
    }];
    return line;
}

- (UIView *)addTopLineWithLeft:(CGFloat)left right:(CGFloat)right{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.left.mas_equalTo(left);
        make.right.mas_equalTo(right);
        make.height.offset(ONE_PIXEL);
    }];
    
    return line;
}

- (UIView *)addBottomLineWithLeft:(CGFloat)left right:(CGFloat)right{
    
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(0);
        make.left.mas_equalTo(left);
        make.right.mas_equalTo(right);
        make.height.offset(ONE_PIXEL);
    }];
    
    return line;
}

- (UIView *)addHorizontalLineWithTop:(CGFloat)top left:(CGFloat)left right:(CGFloat)right{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(top);
        make.left.mas_equalTo(left);
        make.right.mas_equalTo(right);
        make.height.offset(ONE_PIXEL);
    }];
    return line;
}

- (UIView *)addHorizontalLineWithBottom:(CGFloat)bottom left:(CGFloat)left right:(CGFloat)right{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(bottom);
        make.left.mas_equalTo(left);
        make.right.mas_equalTo(right);
        make.height.offset(ONE_PIXEL);
    }];
    return line;
}

- (UIView *)addVerticalLineWithLeft:(CGFloat)left top:(CGFloat)top bottom:(CGFloat)bottom{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(top);
        make.left.mas_equalTo(left);
        make.bottom.mas_equalTo(bottom);
        make.width.offset(ONE_PIXEL);
    }];
    return line;
}

- (UIView *)addVerticalLineWithRight:(CGFloat)right top:(CGFloat)top bottom:(CGFloat)bottom{
    UIView *line = [self addLineWithoutFrame];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(top);
        make.right.mas_equalTo(right);
        make.bottom.mas_equalTo(bottom);
        make.width.offset(ONE_PIXEL);
    }];
    return line;
}
@end