//
//  GMEmptyView.m
//  Gengmei
//
//  Created by Terminator on 15/10/16.
//  Copyright © 2015年 Wanmeichuangyi. All rights reserved.
//

#import "GMEmptyView.h"
#import "GMFont.h"
#import <Masonry/Masonry.h>
#import "GMConstant.h"
#import "GMTheme.h"

@implementation GMEmptyView

- (void)setup {
    [super setup];
    
    _imageView = [[GMImageView alloc] init];
    [self addSubview:_imageView];
    
    _promoptLabel = [[GMLabel alloc] init];
    _promoptLabel.textAlignment = NSTextAlignmentCenter;
    _promoptLabel.font = GMFont(14);
    _promoptLabel.textColor = SECONDARY_TEXT_COLOR;
    [self addSubview:_promoptLabel];
    
    _actionButton = [[GMButton alloc] init];
    _actionButton.titleLabel.font = GMFont(14);
    _actionButton.layer.borderWidth = ONE_PIXEL;
    _actionButton.layer.borderColor = SECONDARY_TEXT_COLOR.CGColor;
    _actionButton.titleLabel.textColor = SECONDARY_TEXT_COLOR;
    [_actionButton setTitleColor:SECONDARY_TEXT_COLOR forState:UIControlStateNormal];
    [self addSubview:_actionButton];
}

- (void)updateConstraints {
    [super updateConstraints];
    [_imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(122);

        make.centerX.mas_equalTo(0);
    }];
    
    [_promoptLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(_imageView.mas_bottom).offset(15);
    }];
    
    [_actionButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(_promoptLabel.mas_bottom).offset(15);
        make.width.mas_equalTo(120);
    }];
    
}
@end
