//
//  GMHightlightLabel.h
//  Gengmei
//
//  Created by wangyang on 6/11/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <GMKit/GMLabel.h>

/**
 *  @brief 设置font，textColor，及GMHightlightLabel特有的lineHeight、hightlightColor以配置要显示的字符串属性
 */
@interface GMHighlightLabel : GMLabel

/**
 *  @brief  对齐方式
 */
@property (nonatomic, assign) NSTextAlignment aligment;


/**
 *  @brief  行高
 */
@property (nonatomic, assign) CGFloat lineHeight;


/**
 *  @brief  默认是 MAIN_VISUL_COLOR
 */
@property (nonatomic, strong) UIColor *hightlightColor;


/**
 *  @brief  默认是 MAIN_VISUL_COLOR
 */
@property (nonatomic, strong) UIColor *normalColor;

/**
 *  @brief  带高亮标志的原始字符串
 *
 */
@property (nonatomic, copy) NSString *originalHightlightText;

/**
 *  @author licong, 16-12-30 18:12:58
 *
 *  创建一个高亮lable
 *
 *  @param color label颜色
 *  @param font  title的font大小
 *
 *  @return 一个高亮lable
 *
 *  @since 5.8
 */
+ (GMHighlightLabel *)hightLabelTextColor:(UIColor *)color andFont:(CGFloat)font;

@end
