//
//  GMScrollView.h
//  Gengmei
//
//  Created by wangyang on 15/12/3.
//  Copyright © 2015年 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSInteger, GMScrollViewLayout) {
    GMScrollViewLayoutHorizontal,
    GMScrollViewLayoutVertical
};

@interface GMScrollView : UIScrollView

/**
 *  @author licong, 16-12-30 18:12:22
 *
 *  初始化方法
 *
 *  @since 5.8
 */
- (void)setup;


#pragma mark - 便捷的添加subview的方法
@property (nonatomic, strong) UIView *container;

@property(nonatomic) UIEdgeInsets contentInset;

/**
 *  @author wangyang, 16-12-31 16:12:37
 *
 *  @brief subview的排布方向，默认是 GMScrollViewLayoutHorizontal
 *  @since 5.8.0
 */
@property (nonatomic, assign) GMScrollViewLayout layout;

@property (nonatomic, assign) CGSize itemSize;
@property (nonatomic, assign) CGFloat innerSpace;

// 点击某一个item
@property (nonatomic, copy) void (^itemClickBlock)(NSInteger index);
/**
 *  @author licong, 16-12-30 18:12:38
 *
 *  在scrollview上用约束进行布局，加上一个container，比较好布局
 *
 *  @param view 将要在contaner上的view
 *
 *  @since 5.8
 */
- (void)containerAppendSubview:(UIView *)view;

/**
 *  @author wangyang, 16-12-31 16:12:12
 *
 *  @brief 给 subview 添加约束
 *  @since 5.8.0
 */
- (void)containerLayoutSubview;

/**
 *  @author licong, 16-12-30 18:12:28
 *
 *  删除container上所有的子视图
 *
 *  @since 5.8
 */
- (void)containerRemoveAllSubviews;

@end
