//
//  Phobos.m
//  GMCache
//
//  Created by Locus on 2019/12/25.
//

#import "Phobos.h"
#import "OldPhobos.h"
#import "NewPhobos.h"

static Phobos *sharedClient = nil;
static BOOL isGray = NO;

@interface Phobos ()

@property (nonatomic, strong) OldPhobos *oldPhobos;
@property (nonatomic, strong) NewPhobos *rePhobos;


@end

@implementation Phobos

/**
 *  @brief 开启Phobos统计,默认以BATCH方式发送log.
 *
 *  @param appName  通常由数据端与客户端一起确认的区分不同app的名字
 *  @param channelId 发布渠道
 *
 *  @return Phobos实例
 *
 *  @since 0.0.1
 */
+ (Phobos *)clientWithAppName:(NSString *)appName channelId:(NSString *)channelId {
    return [[self alloc] initWithAppName:appName channelId:channelId];
}

+ (instancetype)sharedClient {
    return sharedClient;
}

+ (void)setSharedClient:(Phobos *)client {
    sharedClient = client;
}

- (instancetype)initWithAppName:(NSString *)appName channelId:(NSString *)channelId{
    if (self = [super init]) {
        isGray = [[[NSUserDefaults standardUserDefaults] objectForKey:PhobosGray] boolValue];
        // isGray在config接口获取，会保存在NSUserDefaults的PhobosGray中，当次不使用，在下一次冷启动通过该灰度，初始化埋点库
        if (isGray) {
            _rePhobos = [NewPhobos clientWithAppName:appName channelId:channelId];
            sharedClient = _rePhobos;
            _rePhobos.isGray = YES;
        } else {
            _oldPhobos = [OldPhobos clientWithAppName:appName channelId:channelId];
            [OldPhobos setSharedClient:_oldPhobos];
            sharedClient = _oldPhobos;
        }
    }
    return self;
}

+ (void)onClickButtonWithAttributes:(NSDictionary *)attributes {
    if (isGray) {
        [NewPhobos onClickButtonWithAttributes:attributes];
    } else {
        [self track:@"on_cick_button" attributes:attributes];
    }
}

+ (void)onClickButtonWithAttributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow {
    if (isGray) {
        [NewPhobos onClickButtonWithAttributes:attributes sendNow:sendNow];
    } else {
        [self track:@"on_cick_button" attributes:attributes sendNow:sendNow];
    }
}

+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes {
    if (isGray) {
        [NewPhobos track:eventId attributes:attributes];
    } else {
        [OldPhobos track:eventId attributes:attributes];
    }
}

+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow {
    if (isGray) {
        [NewPhobos track:eventId attributes:attributes sendNow:sendNow];
    } else {
        [OldPhobos track:eventId attributes:attributes sendNow:sendNow];
    }
}

+ (void)track:(NSString *)eventId {
    if (isGray) {
        [NewPhobos track:eventId];
    } else {
        [OldPhobos track:eventId];
    }
}

+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes currentAPI:(NSString *)currentAPI {
    if (isGray) {
        [NewPhobos track:eventId attributes:attributes currentAPI:currentAPI];
    } else {
        [OldPhobos track:eventId attributes:attributes currentAPI:currentAPI];
    }
}

+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow currentAPI:(NSString *)currentAPI {
    if (isGray) {
        [NewPhobos track:eventId attributes:attributes sendNow:sendNow currentAPI:currentAPI];
    } else {
        [OldPhobos track:eventId attributes:attributes sendNow:sendNow currentAPI:currentAPI];
    }
}

+ (void)track:(NSString *)eventId currentAPI:(NSString *)currentAPI {
    if (isGray) {
        [NewPhobos track:eventId currentAPI:currentAPI];
    } else {
        [OldPhobos track:eventId currentAPI:currentAPI];
    }
}
/**
 *  @brief PV事件开始。当controller viewWillAppear时调用
 */
- (void)onPVStart:(UIResponder<PhobosPVProtocol> *)page {
    [_rePhobos onPVStart:page];
    [_oldPhobos onPVStart:page];
}
/**
 *  @brief PV事件结束。当controller viewWillDisAppear时调用
 */
- (void)onPVEnd:(UIResponder<PhobosPVProtocol> *)page {
    [_rePhobos onPVEnd:page];
    [_oldPhobos onPVEnd:page];
}

/**
 * 为隐私弹窗触发on_app_session_over埋点使用
 */
- (void)handleAppInBackgound {
    if (isGray) {
        [_rePhobos handleAppInBackgound];
    } else {
        [_oldPhobos handleAppInBackgound];
    }
}

- (void)setCaptureNullExpection:(void (^)(NSString * _Nonnull, NSDictionary * _Nonnull))captureNullExpection {
    _captureNullExpection = captureNullExpection;
    _rePhobos.captureNullExpection = captureNullExpection;
    _oldPhobos.captureNullExpection = captureNullExpection;
}

- (void)setNetStatus:(NSString *)netStatus {
    _netStatus = netStatus;
    _rePhobos.netStatus = netStatus;
    _oldPhobos.netStatus = netStatus;
}

- (void)setNetworkStatus:(NSString *)networkStatus {
    _networkStatus = networkStatus;
    _rePhobos.networkStatus = networkStatus;
    _oldPhobos.networkStatus = networkStatus;
}

- (void)setLogEnabled:(BOOL)logEnabled {
    _logEnabled = logEnabled;
    _rePhobos.logEnabled = logEnabled;
    _oldPhobos.logEnabled = logEnabled;
}

- (void)setUserId:(NSString *)userId {
    _userId = userId;
    _rePhobos.userId = userId;
    _oldPhobos.userId = userId;
}

- (void)setCurrentCityId:(NSString *)currentCityId {
    _currentCityId = currentCityId;
    _rePhobos.currentCityId = currentCityId;
    _oldPhobos.currentCityId = currentCityId;
}

- (void)setGps:(CLLocation *)gps {
    _gps = gps;
    _rePhobos.gps = gps;
    _oldPhobos.gps = gps;
}

- (void)setUserType:(NSMutableDictionary *)userType {
    _userType = userType;
    _rePhobos.userType = userType;
    _oldPhobos.userType = userType;
}

- (void)setApiHost:(NSString *)apiHost {
    _apiHost = apiHost;
    _rePhobos.apiHost = apiHost;
    _oldPhobos.apiHost = apiHost;
}

- (void)setServerAPI:(NSString *)serverAPI {
    _serverAPI = serverAPI;
    _rePhobos.serverAPI = serverAPI;
    _oldPhobos.serverAPI = serverAPI;
}

-(void)setCookie:(NSString *)cookie {
    _cookie = cookie;
    _rePhobos.cookie = cookie;
    _oldPhobos.cookie = cookie;
}

- (void)setGreyType:(NSString *)greyType {
    _greyType = greyType;
    _rePhobos.greyType = greyType;
    _oldPhobos.greyType = greyType;
}

- (void)setSigningType:(PhobosSigningType)signingType {
    _signingType = signingType;
    _rePhobos.signingType = signingType;
    _oldPhobos.signingType = signingType;
}

- (void)setGetTopController:(UIViewController * _Nonnull (^)(void))getTopController {
    _getTopController = getTopController;
    _rePhobos.getTopController = getTopController;
    _oldPhobos.getTopController = getTopController;
}

@end


@implementation Phobos (UtilTest)

/** 获取待发送埋点数量 */
+ (NSUInteger)fetchToBeSendPhobosDataCount {
    return isGray ? [NewPhobos fetchToBeSendPhobosDataCount] : 0;
}

/** 获取待发送埋点数据 */
+ (NSArray *)fetchToBeSendPhobosData {
    return isGray ? [NewPhobos fetchToBeSendPhobosData] : @[];
}

/** 清除待发送埋点数据缓存 */
+ (void)removeAllPhobosData {
    if (isGray) {
        [NewPhobos removeAllPhobosData];
    }
}

@end
