//
//  GMRefreshHeader.m
//  MJRefreshExample
//
//  Created by wangyang on 16/3/1.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import "GMRefreshHeader.h"
#import "GMRefreshConstant.h"
#import "MJRefreshComponent+Private.h"
@import GMPhobos;

#define GM_REFRESH_WIDTH            46
#define GM_REFRESH_HEIGHT           14

@implementation GMRefreshHeader
{
    UIImageView *_prepareImageView;
}
- (void)prepare
{
    [super prepare];
    
    // 隐藏时间
    self.lastUpdatedTimeLabel.hidden = YES;
    
    // 隐藏状态
    self.stateLabel.hidden = YES;
    [self setImages:@[[UIImage imageNamed:GMRefreshImageName(@"pullLoading1")]] forState:MJRefreshStatePulling];

    // 设置正在刷新状态的动画图片
    NSMutableArray *refreshingImages = [NSMutableArray array];
    for (NSUInteger i = 1; i<=23; i++) {
        NSString *imageName = [NSString stringWithFormat:@"pullLoading%ld", i];
        NSString *imagePath = GMRefreshImageName(imageName);
        UIImage *image = [UIImage imageNamed:imagePath];
        [refreshingImages addObject:image];
    }
    [self setImages:refreshingImages forState:MJRefreshStateRefreshing];


    // 手动下拉过程中的图片
//    _prepareImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:GMRefreshImageName(@"pullLoading1")]];
//    _prepareImageView.mj_w = GM_REFRESH_WIDTH;
//    _prepareImageView.mj_h = GM_REFRESH_HEIGHT;
//
//    _prepareImageView.mj_y = self.mj_h -_prepareImageView.mj_h / 2;
//
//    _prepareImageView.mj_x = (self.mj_w - _prepareImageView.mj_w) / 2;
//
//    _prepareImageView.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin | UIViewAutoresizingFlexibleRightMargin;
//    _prepareImageView.hidden = YES;
//    [self addSubview:_prepareImageView];
}

- (void)setPullingPercent:(CGFloat)pullingPercent
{
    [super setPullingPercent:pullingPercent];
    
    // 隐藏时间
    self.lastUpdatedTimeLabel.hidden = YES;
    
    // 隐藏状态
    self.stateLabel.hidden = YES;
    
    if (self.state == MJRefreshStateIdle && pullingPercent != 0.0) {
        _prepareImageView.hidden = NO;
        if (pullingPercent <= 1.0 ) {
            // 下拉过程中
            self.gifView.hidden = YES;
            CGFloat translation = self.mj_h * pullingPercent / 2;

            _prepareImageView.transform = CGAffineTransformMakeTranslation(0, -translation);
            _prepareImageView.transform = CGAffineTransformScale(_prepareImageView.transform, pullingPercent, pullingPercent);
        }else{

            // pullingPercent 超过 1 时，位置固定
            self.gifView.hidden = NO;
            CGFloat translation = self.mj_h * 1 / 2;
            CGFloat scale = MIN(1.0, pullingPercent);

            _prepareImageView.transform = CGAffineTransformMakeTranslation(0, -translation);
            _prepareImageView.transform = CGAffineTransformScale(_prepareImageView.transform, scale, scale);
        }
    }
}

- (void)endRefreshing {
    [super endRefreshing];

    // 如果导航栏有透明效果，在下拉刷新后，会看到有动画图片在导航栏下面，通过reveal检查发现，其实_prepareImageView 和 gifView都是显示状态，所以两个都需要隐藏
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(MJRefreshFastAnimationDuration * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        _prepareImageView.hidden = YES;
        self.gifView.hidden = YES;
    });
}

- (void)executeRefreshingCallback
{
    // 下拉加载时，页面下拉次数++，同时将当前数据进行上报
//    self.pageCtrl.down_loading_times++;
//    [[GMExposureManager sharedManager] endExpoTrcakerForPageCtrl:self.pageCtrl];
    dispatch_async(dispatch_get_main_queue(), ^{
        MJRefreshFooter *footer = _scrollView.mj_footer;
        if (footer && [footer isRefreshing]) {
            [self endRefreshing];
        } else {
            if (self.refreshingBlock) {
                self.refreshingBlock();
            }
            if ([self.refreshingTarget respondsToSelector:self.refreshingAction]) {
                MJRefreshMsgSend(MJRefreshMsgTarget(self.refreshingTarget), self.refreshingAction, self);
            }
            if (self.beginRefreshingCompletionBlock) {
                self.beginRefreshingCompletionBlock();
            }
        }
    });
    NSString *pageName = [self myViewController].pageName ?: @"";
    [Phobos track:@"refresh_page" attributes:@{@"page_name":pageName}];
}

@end
