//
//  GMGifImageView.m
//  Gengmei
//
//  Created by lizhen on 2019/3/15.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "GMGifImageView.h"
#import <MJRefresh/MJRefresh.h>

#import "GMRefreshConstant.h"

#define imgCount 16

@interface GMGifImageView ()
@property (nonatomic, strong) NSMutableArray *refreshingImages;
@property (nonatomic, strong) UITableView *table;
@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, assign) BOOL isTable;
@end

@implementation GMGifImageView

- (instancetype)initWithSuperView:(UIView *)superView {
    if (self = [super init]) {
        if ([superView isKindOfClass:[UICollectionView class]]) {
            self.isTable = NO;
            self.collectionView = (UICollectionView *)superView;
        } else if ([superView isKindOfClass:[UITableView class]]) {
            self.isTable = YES;
            self.table = (UITableView *)superView;
        }
        self.hidden = YES;
        NSTimeInterval duration = self.refreshingImages.count*0.1;
        self.animationImages = self.refreshingImages;
        self.animationRepeatCount = MAXFLOAT;
        self.animationDuration = duration;
        [superView addSubview:self];
        CGFloat width = 100;
        CGFloat height = 130;
        CGFloat x = (superView.frame.size.width -width) * 0.5;
        self.frame = CGRectMake(x, -130, width, height);

 
    }
    return self;
}

- (NSMutableArray *)refreshingImages {
    if (!_refreshingImages) {
        _refreshingImages = [NSMutableArray arrayWithCapacity:1];
        for (NSUInteger i = 1; i<=imgCount; i++) {
            
            NSString *imageName = [NSString stringWithFormat:@"pullLoading%ld", i];
            NSString *imagePath = GMRefreshImageName(imageName);
            UIImage *image = [UIImage imageNamed:imagePath];
            
            [_refreshingImages addObject:image];
        }
    }
    return _refreshingImages;
}

- (void)startGifRefresh:(BOOL)topAnimation {
    /* 根据图片设置控件的高度 */
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        self.hidden = NO;
        [self startAnimating];
    });
    if (self.isTable) {
        [self.table setContentOffset:CGPointZero animated:topAnimation];
        [self.table.mj_header beginRefreshing];
    } else {
        [self.collectionView setContentOffset:CGPointZero animated:topAnimation];
        [self.collectionView.mj_header beginRefreshing];
    }
}

- (void)stopGifRefresh {
    [self stopAnimating];
    self.hidden = YES;
}

@end
