//
//  GMRefreshFooter.m
//  GengmeiDoctor
//
//  Created by Terminator on 16/4/29.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import "GMRefreshFooter.h"
#import "GMRefreshConstant.h"
#import "MJRefreshComponent+Private.h"
@import GMPhobos;

@interface GMRefreshFooter()
@property (nonatomic, strong) UIImageView *prepareImageView;
@end
@implementation GMRefreshFooter

- (void)prepare
{
    [super prepare];
    //隐藏文字显示
    self.refreshingTitleHidden = YES;
    self.stateLabel.hidden = YES;
    // 设置正在刷新状态的动画图片
    NSMutableArray *refreshingImages = [NSMutableArray array];
    for (NSUInteger i = 1; i<=20; i++) {
        NSString *imageName = [NSString stringWithFormat:@"pullLoading%ld", i];
        NSString *imagePath = GMRefreshImageName(imageName);
        UIImage *image = [UIImage imageNamed:imagePath];
        [refreshingImages addObject:image];
    }
    [self setImages:refreshingImages forState:MJRefreshStateRefreshing];
}

- (void)executeRefreshingCallback
{
    dispatch_async(dispatch_get_main_queue(), ^{
        MJRefreshHeader *header = _scrollView.mj_header;
        if (header && [header isRefreshing]) {
            [self endRefreshing];
        } else {
            if (self.refreshingBlock) {
                self.refreshingBlock();
            }
            if ([self.refreshingTarget respondsToSelector:self.refreshingAction]) {
                MJRefreshMsgSend(MJRefreshMsgTarget(self.refreshingTarget), self.refreshingAction, self);
            }
            if (self.beginRefreshingCompletionBlock) {
                self.beginRefreshingCompletionBlock();
            }
        }
    });
    NSString *pageName = [self myViewController].pageName ?: @"";
    [Phobos track:@"upload_page" attributes:@{@"page_name":pageName}];
}
@end
