//
//  GMNavigationController.m
//  GMRouter_Example
//
//  Created by Q14 on 2020/8/10.
//  Copyright © 2020 Q14. All rights reserved.
//

#import "GMNavigationController.h"
@interface UINavigationController (UINavigationControllerNeedShouldPopItem)
- (BOOL) navigationBar:(UINavigationBar *)navigationBar shouldPopItem:(UINavigationItem *)item;
@end

@interface GMNavigationController ()

@end

@implementation GMNavigationController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}


// UINavigationBarDelegate
- (BOOL) navigationBar:(UINavigationBar *)navigationBar shouldPopItem:(UINavigationItem *)item {

 NSUInteger count = self.viewControllers.count;
    NSUInteger itemsCount = navigationBar.items.count;

    if(count < itemsCount){
        return YES;
    }

    UIViewController *vc = self.topViewController;
    if([vc respondsToSelector:@selector(shouldPopOnBackButtonPress)]){
        if([vc performSelector:@selector(shouldPopOnBackButtonPress)]){
            // 此处调用父类的navigationBar: shouldPopItem:，但是父类并没有暴露此方法，在这里可以调用因为上面的Category  - UINavigationControllerNeedShouldPopItem
            return [super navigationBar:navigationBar shouldPopItem:item];
        }else{
            [self setNavigationBarHidden:YES];
            [self setNavigationBarHidden:NO];
            return NO;
        }
    }else{
        return [super navigationBar:navigationBar shouldPopItem:item];
    }
}
@end
