//
//  GMROuterTool.m
//  GMRouter_Example
//
//  Created by Q14 on 2020/8/10.
//  Copyright © 2020 Q14. All rights reserved.
//

#import "GMRouterTool.h"

@implementation GMRouterTool
+ (UIViewController *)getRootViewController {

    UIWindow* window = [[[UIApplication sharedApplication] delegate] window];
    return window.rootViewController;
}


+ (UIViewController *)getCurrentViewController {

    UIViewController* currentViewController = [self getRootViewController];

    if (currentViewController.presentedViewController) { //present
        currentViewController = currentViewController.presentedViewController;
        return currentViewController;
    } else if ([currentViewController isKindOfClass:NSClassFromString(@"WMMainTabBarViewController")]) { //一级页面
        UIViewController *vc =  (UIViewController *)[currentViewController valueForKey:@"current"];
        return vc;
    } else {
        UINavigationController* navigationController = (UINavigationController* )currentViewController;
        currentViewController = navigationController.visibleViewController;
        return currentViewController;
    }
}
@end
