//
//  GMRouter+gm.h
//  GMRouter
//
//  Created by Q14 on 2019/11/28.
//

#import "GMRouter.h"
#import "UIResponder+router.h"

NS_ASSUME_NONNULL_BEGIN

extern NSString *const GMRouterProtocolPrefix;
@interface GMRouter (gm)

/**
* 添加的模块例如： Target_common
*/
@property (nonatomic, strong) NSMutableArray *targets;

/**
* 通过协议 跳转到对应的vc
* @param urlScheme 协议名字
* 例如gengmei://welfare_special?service_id=5930&is_new_special=0
* @return vc的实例
*/
- (id)pushScheme:(NSString *)urlScheme;

/**
* 通过协议 跳转到对应的vc
* @param urlScheme 协议名字
* 例如gengmei://welfare_special?service_id=5930&is_new_special=0
* @param routerBlock 需要回调的block
* @return vc的实例
*/
- (id)pushScheme:(NSString *)urlScheme completeBlock:(GMRouterBlock)routerBlock;

/**
 * 通过协议 跳转到对应的vc
 * @param urlScheme vc类名称
 * 例如gengmei://welfare_special
 * @param params 创建vc初始化要传递的参数
 * {@"service_id": @"5930",@"is_new_special": @0}
 * @return vc的实例
 */
- (id)pushScheme:(NSString *)urlScheme params:(NSDictionary *)params routerBlock:(GMRouterBlock)routerBlock;

/**
* 初始化Map
*
*/
- (void)initializeRouteMap;
@end

NS_ASSUME_NONNULL_END
