//
//  GMRouter+gm.m
//  GMRouter
//
//  Created by Q14 on 2019/11/28.
//

#import "GMRouter+gm.h"
#import <GMPhobos/GMPhobos-umbrella.h>
#import <objc/message.h>
#import <objc/runtime.h>

// 忽略警告
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wundeclared-selector"
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"

NSString *const GMRouterActionPrefix = @"Action_";
NSString *const GMRouterActionSuffix = @":";
NSString *const GMRouterTargetPrefix = @"Target_";
NSString *const GMRouterProtocolPrefix = @"gengmei://";
/**
 增加一个模块, 需要在路由做映射,
 TODO: 后续改为数组的形式传过来
 */
NSString *const GMRouterTargetAI = @"Target_AI";
NSString *const GMRouterTargetBanking = @"Target_Banking";
NSString *const GMRouterTargetCommunity = @"Target_Community";
NSString *const GMRouterTargetWeb = @"Target_Web";

static NSMutableDictionary *routeMap = nil;

@implementation GMRouter (gm)

- (void)initializeRouteMap {
    routeMap = [[NSMutableDictionary alloc] initWithCapacity:50];
    self.targets = [NSMutableArray arrayWithObjects:GMRouterTargetAI, GMRouterTargetBanking, GMRouterTargetCommunity, GMRouterTargetWeb, nil];
}


- (id)pushScheme:(NSString *)urlScheme {
    return [self pushScheme:urlScheme completeBlock:NULL];
}

- (id)pushScheme:(NSString *)urlScheme completeBlock:(GMRouterBlock)routerBlock {
    NSString *encodeUrlScheme;
    if ([encodeUrlScheme hasPrefix:GMRouterProtocolPrefix]) {
        encodeUrlScheme = [self URLEncodeString:urlScheme];
    } else {
        encodeUrlScheme = [NSString stringWithFormat:@"%@%@", GMRouterProtocolPrefix ,urlScheme];
    }
    
    NSDictionary *params = [self getParams:encodeUrlScheme];
    return [self pushScheme:urlScheme params:params completeBlock:routerBlock];
}

- (id)pushScheme:(NSString *)urlScheme params:(NSDictionary *)params completeBlock:(GMRouterBlock)routerBlock {
    NSMutableDictionary *allParams = [NSMutableDictionary dictionaryWithDictionary:params];
    
    NSString *encodeUrlScheme = [self URLEncodeString:urlScheme];
    
    NSString *host = [self getHost:urlScheme];
    NSString *targetName = [routeMap objectForKey:host];
    NSDictionary *paramsDict = [self getParams:encodeUrlScheme];
    [allParams addEntriesFromDictionary:paramsDict];
    host = [self safeHostWithEncodeUrlScheme:encodeUrlScheme host:host];
    id vc = [self performTarget:targetName action:host params:params shouldCacheTarget:NO];
    
    //如果是push 过来的 或者需要回调的在此赋值
    if ([vc isKindOfClass:[UIViewController class]]) {
        UIViewController *VC = (UIViewController *)vc;
        [self vcAutoIsPushWith:vc params:params];
    }
    
    // 赋值回调过程
    if ([vc isKindOfClass:[UIResponder class]]) {
        UIResponder *VC = (UIResponder *)vc;
        __weak typeof(self) weakSelf = self;
        VC.routerBlock = ^(NSDictionary * _Nonnull params) {
            routerBlock(params);
        };
    }
    return vc;
}

// 获取host
- (NSString *)getHost:(NSString *)encodeUrlScheme {
    NSURL *url = [NSURL URLWithString:encodeUrlScheme];
    if (!url) {
        //        debugLog(@"协议出错了!");
    }
    return url.host;
}


#pragma mark - 处理协议后面待的参数
- (NSDictionary *)getParams:(NSString *)encodeUrlScheme {
    NSString *host = [self getHost:encodeUrlScheme];
    NSDictionary *params;
    NSArray *array = [encodeUrlScheme componentsSeparatedByString:@"url="];
    if (([host isEqualToString:@"third_webview"] || [host isEqualToString:@"common_webview"]) && array.count > 1) {
        NSString *value = array[1];
        //拦截所有的即将调转的url(value),如果不在白名单之中,让其使用GMThirdWebViewController加载. 必须要用while 因为url部分包含 %3A  gengmei://common_webview?url=http%3A//backend.paas.env/hybrid/base_wiki/item/285
        while ([value rangeOfString:@"%"].length != 0) {
            value = [self URLDecodedString:value];
        }
        NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithDictionary:[self urlQueryToDictionary:value]];
        [dict setValue:value forKey:@"url"];
        params = dict;
    } else {
        params = [self urlQueryToDictionary:encodeUrlScheme];
    }
    return params;
}

// 如果不在白名单的三方url  禁止获取我们APP内重要信息
- (NSString *)safeHostWithEncodeUrlScheme:(NSString *)encodeUrlScheme host:(NSString *)host {
    NSArray *array = [encodeUrlScheme componentsSeparatedByString:@"url="];
    if (([host isEqualToString:@"third_webview"] || [host isEqualToString:@"common_webview"]) && array.count > 1) {
        NSString *value = array[1];
        while ([value rangeOfString:@"%"].length != 0) {
            value = [ self URLDecodedString:value];
        }
        //拦截所有的即将调转的url(value),如果不在白名单之中,让其使用GMThirdWebViewController加载.
        NSString *valueHost = [[NSURL URLWithString:value] host];
        Class cls = NSClassFromString(@"GMServerDomains");
#pragma GCC diagnostic ignored "-Wundeclared-selector"
        if (valueHost.length != 0 && [cls respondsToSelector:@selector(allowURLHost:)]) {
            BOOL isAllow = [cls performSelector:@selector(allowURLHost:) withObject:valueHost];
            if (!isAllow) {
                host = @"third_webview";
            }
        }
    }
    return host;
}

#pragma mark - autoIsPush
- (void)vcAutoIsPushWith:(UIViewController *)vc  params:(NSDictionary *)params {
    if (vc != nil && ([params.allKeys containsObject:@"ispush"])) {
        // 区分是否是推送，指定页面：日记本详情页、讨论帖、问答详情页、回答详情页
        // 不支持third_webview和common_webview
        if ([params[@"ispush"] isEqualToString:@"1"]) {
            [vc setSourceFromPushWithMessageId:params[@"message_id"]];
        }
    }
}

#pragma mark - string to dict
- (NSDictionary*)urlQueryToDictionary:(NSString *)urlScheme {
    NSURL* url1 = [NSURL URLWithString:urlScheme];
    if (!url1) {
        return nil;
    }
    NSString *query = [url1 query];
    return [self queryToDictionary:query];
}



- (NSDictionary*)queryToDictionary:(NSString *)query {
    @try {
        NSMutableDictionary* dict = [NSMutableDictionary dictionary];
        NSArray* components = [query componentsSeparatedByString:@"&"];
        for (NSString* component in components) {
            NSArray* keyValue = [component componentsSeparatedByString:@"="];
            if ([keyValue count] > 1) {
                NSString * key = [self URLDecodedString:[keyValue objectAtIndex:0]];
                NSString * value = [keyValue objectAtIndex:1];
                
                //参数中依然包含超过2个“=”号（多数发生在common_webview后的url参数中），则后面的数组的元素需要拼接成一个字符串
                if ([keyValue count]>2) {
                    for (int i=2; i<[keyValue count]; i++) {
                        value=[value stringByAppendingString:@"="];
                        value=[value stringByAppendingString:keyValue[i]];
                    }
                }
                
                //因为这种情况服务器和客户端都转义了一次，所以要两次反转义还原中文
                while ([value rangeOfString:@"%"].length != 0) {
                    value = [self URLDecodedString:value];
                }
                [dict setObject: value forKey: key];
            }
        }
        return dict;
    }
    @catch (NSException *exception) {}
}

- (NSString*)URLDecodedString:(NSString *)urlStr {
    NSString *result = (NSString *)CFBridgingRelease(CFURLCreateStringByReplacingPercentEscapesUsingEncoding(kCFAllocatorDefault, (CFStringRef)urlStr, CFSTR(""), kCFStringEncodingUTF8));
    return result;
}

- (NSString *)URLEncodeString:(NSString *)urlStr {
    NSString *encodedString = [urlStr stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
    return encodedString;
}

- (NSMutableArray *)targets {
    return objc_getAssociatedObject(self, @selector(targets));
}

//设置 targets且添加方法列表
- (void)setTargets:(NSMutableArray *)targets {
    objc_setAssociatedObject(self, @selector(targets), targets, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    for (NSString *clsStr in targets) {
        NSDictionary *dict = [self getMethods:clsStr];
        [routeMap addEntriesFromDictionary:dict];
    }
}

#pragma mark - 获取类的所有方法
// 获取所有的方法
- (NSDictionary *)getMethods:(NSString *)clsStr {
    Class cls = NSClassFromString(clsStr);
    NSRange range = [clsStr rangeOfString:@"Target_"];
    NSString *targetValue =  [clsStr substringFromIndex:range.length];
    
    NSAssert(targetValue.length != 0, @"Target_后不能为空！请注意Target");
    
    unsigned int count = 0;
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    
    // 获取类的所有 Method
    Method *methods = class_copyMethodList([cls class], &count);
    
    for (NSUInteger i = 0; i < count; i ++) {
        // 获取方法 Name
        SEL methodSEL = method_getName(methods[i]);
        const char *methodName = sel_getName(methodSEL);
        NSString *name = [NSString stringWithUTF8String:methodName];
        
        //获取到的是这样的 pushToHospitalDetail: 因此要去掉：
        NSString *rangeStr = @":";
        if ([name containsString:rangeStr]) {
            NSRange range = [name rangeOfString:rangeStr];
            name = [name substringToIndex:range.location];
        }
        NSString *promoteStr = [NSString stringWithFormat:@"%@-内有重复的方法名-%@", clsStr, name];
        NSAssert(![dict.allKeys containsObject:name], promoteStr);
        
        //因为消息发送的时候会有两个默认的参数（消息接收者和方法名），所以需要减去2
        dict[name] = targetValue;
    }
    
    free(methods);
    return dict;
}
@end
