module Pod
  class Downloader
    def self.for_source(source, pod_root)
      options = source.dup
      if url = options.delete(:git)
        Git.new(pod_root, url, options)
      else
        raise "Unsupported download strategy `#{source.inspect}'."
      end
    end

    def initialize(pod_root, url, options)
      @pod_root, @url, @options = pod_root, url, options
    end

    class Git < Downloader
      require 'rubygems'
      require 'executioner'
      include Executioner
      # TODO make Executioner:
      # * not raise when there's output to either stdout/stderr, but check exit status
      # * sync output
      executable :git

      def source_dir
        @pod_root + 'source'
      end

      def download
        if tag = @options[:tag]
          source_dir.mkdir
          Dir.chdir(source_dir) do
            git "init"
            git "remote add origin '#{@url}'"
            git "fetch origin tags/#{tag} 2>&1"
            git "reset --hard FETCH_HEAD"
            git "checkout -b activated-pod-commit 2>&1"
          end
        elsif commit = @options[:commit]
          git "clone '#{@url}' '#{source_dir}'"
          Dir.chdir(source_dir) do
            git "checkout -b activated-pod-commit #{commit} 2>&1"
          end
        else
          raise "Either a tag or a commit has to be specified."
        end
      end

      def clean
        (source_dir + '.git').rmtree
      end
    end
  end
end
