require 'pathname'

module Pod
  class Config
    def self.instance
      @instance ||= new
    end

    def self.instance=(instance)
      @instance = instance
    end

    attr_accessor :repos_dir, :project_root, :project_pods_root, :rootspec, :clean, :verbose, :silent, :doc, :doc_install, :force_doc
    alias_method :clean?,       :clean
    alias_method :verbose?,     :verbose
    alias_method :silent?,      :silent
    alias_method :doc?,         :doc
    alias_method :doc_install?, :doc_install
    alias_method :force_doc?,   :force_doc

    def initialize
      @repos_dir = Pathname.new(File.expand_path("~/.cocoapods"))
      @clean = true
      @verbose = false
      @silent = false
      @doc = true
      @doc_install = true
      @force_doc = false
    end

    def project_root
      @project_root ||= Pathname.pwd
    end

    def project_pods_root
      @project_pods_root ||= project_root + 'Pods'
    end

    def project_podfile
      @project_podfile ||= project_root + 'Podfile'
    end

    def headers_symlink_root
      @headers_symlink_root ||= "#{project_pods_root}/Headers"
    end

    # Returns the spec at the pat returned from `project_podfile`.
    def rootspec
      @rootspec ||= Podfile.from_file(project_podfile)
    end

    def ios?
      require 'colored'
      caller.find { |line| line =~ /^(.+.podspec):\d*/ }
      puts "[!] The use of `config.ios?` is deprecated and will be removed in version 0.7.#{" Called from: #{$1}" if $1}".red
      rootspec.target_definitions[:default].platform == :ios if rootspec
    end

    def osx?
      require 'colored'
      caller.find { |line| line =~ /^(.+.podspec):\d*/ }
      puts "[!] The use of `config.ios?` is deprecated and will be removed in version 0.7.#{" Called from: #{$1}" if $1}".red
      rootspec.target_definitions[:default].platform == :osx if rootspec
    end

    module Mixin
      def config
        Config.instance
      end
    end
  end
end
