# Contributing

Before creating a issue or pull-request, be sure to search for existing tickets
first and provide additional feedback on those instead.

## Issues

The issues of this repository refer **only** to the development of the CocoaPods
tool. These resources include:

- [CocoaPods](https://github.com/CocoaPods/CocoaPods/issues)
- [CocoaPods/Core](https://github.com/CocoaPods/Core/issues)
- [Xcodeproj](https://github.com/CocoaPods/Xcodeproj/issues)

Please refer to these other resources for things unrelated to the tool itself:

- [Mailing List](http://groups.google.com/group/cocoapods): Usage & general
  questions.
- [CocoaPods/Specs](https://github.com/CocoaPods/Specs/issues): Submit new Pods and
  report broken ones.

Properly written and formatted issues are more likely to receive the
appropriate attention. Or, as we say at Keeping-Sanity-in-OSS-HQ™: _“If you don’t care, we won’t care.”_


#### Bug reports

Please include _all_ relevant information, including the version of CocoaPods and
any template printed by the tool.

If questions in the error template are left unanswered, the issue will be closed
as a bad bug report.

If there is a regression in the projects generated by CocoaPods please include
the output (redacted if needed) of one of the following commands:

```
$ xcodeproj target-diff
$ xcodeproj project-diff
```

If you are familiar with Ruby, making a pull request with a failing test case
can speed up the resolution of the bug. If the issue is more complex you can
add an [integration test](https://github.com/CocoaPods/CocoaPods/tree/master/spec/integration)
which doesn't require any ruby knowledge.


#### Feature requests

Please try to be precise about the proposed outcome of the feature and how it
would related to existing features.


## Pull Requests

We **love** pull requests and if a contribution is significant we tend to offer
push access.

All contributions will be licenced under the MIT license.

