# Do’s and Don’ts

* **Search tickets before you file a new one.** Add to tickets if you have new information about the issue.
* **Only file tickets about the CocoaPods tool itself.** This includes [CocoaPods](https://github.com/CocoaPods/CocoaPods/issues),
  [CocoaPods/Core](https://github.com/CocoaPods/Core/issues), and [Xcodeproj](https://github.com/CocoaPods/Xcodeproj/issues).
  If your question is regarding a library (to be) distributed through CocoaPods, refer to the [spec repo](https://github.com/CocoaPods/Specs).
  If your question is “How do I […]”, then please ask on [StackOverflow](http://stackoverflow.com/search?q=CocoaPods) or our [mailing-list](http://groups.google.com/group/cocoapods).
* **Keep tickets short but sweet.** Make sure you include all the context needed to solve the issue. Don't overdo it. Great tickets allow us to focus on solving problems instead of discussing them.
* **Take care of your ticket.** When you spend time to report a ticket with care we'll enjoy fixing it for you.

## Bug reports

First check if you are using the latest CocoaPods version before filing a ticket.
You can install the latest version with `$ [sudo] gem install cocoapods`.

Please include _all_ relevant information, including the version of CocoaPods and
any template printed by the tool.

If questions in the error template are left unanswered, the issue will be closed
as a bad bug report.

If there is a regression in the projects generated by CocoaPods please include
the output (redacted if needed) of one of the following commands:

```
$ xcodeproj target-diff
$ xcodeproj project-diff
```

If you are familiar with Ruby, making a pull request with a failing test case
can speed up the resolution of the bug. If the issue is more complex you can
add an [integration test](https://github.com/CocoaPods/CocoaPods/tree/master/spec/integration)
which doesn't require any ruby knowledge.


## Feature requests

Please try to be precise about the proposed outcome of the feature and how it
would related to existing features.


## Pull Requests

We **love** pull requests and if a contribution is significant we tend to offer
push access.

All contributions _will_ be licenced under the MIT license.

Code/comments should adhere to the following rules:

* Names should be descriptive and concise.
* Use two spaces and no tabs.
* All changes require test coverage to ensure it does not break during refactor
  work. (There are a few exceptions to this, which can be recognized by there
  not being any coverage for similar code.)
* All enhancements and bug fixes need to be documented in the CHANGELOG.
* When writing comments, use properly constructed sentences, including
  punctuation.
* When documenting APIs and/or source code, don't make assumptions or make
  implications about race, gender, religion, political orientation or anything
  else that isn't relevant to the project.
* Remember that source code usually gets written once and read often: ensure
  the reader doesn't have to make guesses. Make sure that the purpose and inner
  logic are either obvious to a reasonably skilled professional, or add a
  comment that explains it.
