module Pod
  module Hooks
    class TargetInstallerData

      # Stores the information of the target installer

      # @return [Sandbox] sandbox the sandbox where the support files should
      #         be generated.
      #
      attr_accessor :sandbox

      # @return [Library] The library whose target needs to be generated.
      #
      attr_accessor :library

      #-----------------------------------------------------------------------#

      # @todo This has to be removed, but this means the specs have to be
      #       updated if they need a reference to the prefix header.
      #
      def prefix_header_filename
        library.prefix_header_path.relative_path_from(sandbox.root)
      end

      # @return [Project] the Pods project of the sandbox.
      #
      def project
        sandbox.project
      end

      # @return [TargetDefinition] the target definition of the library.
      #
      def target_definition
        library.target_definition
      end

      # @return [PBXNativeTarget] the target generated by the installation
      #         process.
      #
      def target
        library.target
      end
    end
  end
end


