# Load the BridgeSupport metadata generated by CocoaPods from all dependencies.
load_bridge_support_file NSBundle.mainBundle.pathForResource("Pods", ofType:"bridgesupport")

class AppDelegate
  URL = "http://api.twitter.com/1/statuses/user_timeline.json?screen_name=%s"

  attr_accessor :window, :tableView, :reloadButton, :handleTextField

  def awakeFromNib
    @tweets = []
    @handleTextField.stringValue = "alloy"
  end

  def applicationDidFinishLaunching(notification)
    refreshData(nil)
  end

  def refreshData(sender)
    url = NSURL.URLWithString(URL % @handleTextField.stringValue.strip)
    @handleTextField.enabled = @reloadButton.enabled = false

    @request = ASIHTTPRequest.requestWithURL(url)
    @request.completionBlock = lambda do
      puts "Request completed!"
      @tweets = @request.responseString.JSONValue
      @tableView.reloadData
      @handleTextField.enabled = @reloadButton.enabled = true
    end
    @request.failedBlock = lambda do
      puts "Request failed :("
      puts @request.error.localizedDescription
      @handleTextField.enabled = @reloadButton.enabled = true
    end
    @request.startAsynchronous
  end

  def numberOfRowsInTableView(tableView)
    @tweets.size
  end

  def tableView(tableView, objectValueForTableColumn:column, row:row)
    if tweet = @tweets[row]
      tweet['text']
    end
  end
end

