# Do’s and Don’ts

* **Search the solutions in the [troubleshooting guide](http://guides.cocoapods.org/using/troubleshooting.html).** Or any of the many other [guides](http://guides.cocoapods.org).
* **Search tickets before you file a new one.** Add to tickets if you have new information about the issue.
* **Only file tickets about the CocoaPods tool itself.** This includes [CocoaPods](https://github.com/CocoaPods/CocoaPods/issues),
  [CocoaPods/Core](https://github.com/CocoaPods/Core/issues), and [Xcodeproj](https://github.com/CocoaPods/Xcodeproj/issues).
  If your question is regarding a library (to be) distributed through CocoaPods, refer to the [spec repo](https://github.com/CocoaPods/Specs).
  If your question is “How do I […]”, then please ask on [StackOverflow](http://stackoverflow.com/search?q=CocoaPods) or our [mailing-list](http://groups.google.com/group/cocoapods).
* **Keep tickets short but sweet.** Make sure you include all the context needed to solve the issue. Don't overdo it. Great tickets allow us to focus on solving problems instead of discussing them.
* **Take care of your ticket.** When you spend time to report a ticket with care we'll enjoy fixing it for you.
* **Do not litter.** Don’t add +1’s _unless_ specifically asked for and don’t discuss offtopic issues.
* **Spell the name of the project correctly.** It's CocoaPods. In upper camel case.

## Bug Reports

In short, since you are most likely a developer, provide a ticket that you _yourself_ would _like_ to receive.

We are **not** here to support your individual projects. We depend on _you_ (the community)
to contribute in making the tool better for everyone. So debug and reduce your own issues
before creating a ticket and let us know of all the things you tried and their outcome.
This applies double if you cannot share a reproduction with us because of internal company
policies.

First check if you are using the latest CocoaPods version before filing a ticket.
You can install the latest version with `$ [sudo] gem install cocoapods`.

Then check if the same problem applies with the same Podfile but in a **completely new**
and empty application Xcode project, thus excluding whether or not there is an issue with
conflicting settings.

Please include steps to reproduce and _all_ other relevant information, including the
version of CocoaPods and any template printed by the tool.

If questions in the error template are left unanswered, the issue will be closed
as a bad bug report.

If there is a regression in the projects generated by CocoaPods please include
the output (redacted if needed) of one of the following commands:

```
$ xcodeproj target-diff
$ xcodeproj project-diff
```

If you are familiar with Ruby, making a pull request with a failing test case
can speed up the resolution of the bug. If the issue is more complex you can
add an [integration test](https://github.com/CocoaPods/cocoapods-integration-specs/)
which doesn't require any ruby knowledge.


## Feature Requests

Please try to be precise about the proposed outcome of the feature and how it
would related to existing features.

From the [CocoaPods blog](http://blog.cocoapods.org/CocoaPods-0.28/):

> Fighting feature creep in CocoaPods is not easy. We hear about a lot of great ideas and many of them don't make the cut as they would not be useful for at least 80% of our users.

Should you require a feature isn't suited for mainstream users, consider suggesting a [CocoaPods plugin](http://blog.cocoapods.org/CocoaPods-0.28/) instead.


## Pull Requests

We **love** pull requests and if a contribution is significant we tend to offer
push access. We suggest you take a look at our [Contributing guide](http://guides.cocoapods.org/contributing/contribute-to-cocoapods.html) for info on development setup, and some of our best practices.

All contributions _will_ be licensed under the MIT license.

Code/comments should adhere to the following rules:

* Names should be descriptive and concise.
* Use two spaces and no tabs.
* All changes require test coverage to ensure it does not break during refactor
  work. (There are a few exceptions to this, which can be recognised by there
  not being any coverage for similar code.)
* All enhancements and bug fixes need to be documented in the CHANGELOG.
* When writing comments, use properly constructed sentences, including
  punctuation.
* When documenting APIs and/or source code, don't make assumptions or make
  implications about race, gender, religion, political orientation or anything
  else that isn't relevant to the project.
* Remember that source code usually gets written once and read often: ensure
  the reader doesn't have to make guesses. Make sure that the purpose and inner
  logic are either obvious to a reasonably skilled professional, or add a
  comment that explains it.
* The message of the commit should be prefixed by the name of the file which is
  the main focus of the patch enclosed by square brackets (.e.g. `[Installer]
  install pods`).


## [No Brown M&M’s](http://en.wikipedia.org/wiki/Van_Halen#Contract_riders)

If you made it all the way to the end, bravo dear user, we love you. You can include
this emoji in the top of your ticket to signal to us that you did in fact read this
file and are trying to conform to it as best as possible: 🌈
