require File.expand_path("../../../../spec_helper", __FILE__)

describe Pod::Generator::Markdown do
  before do
    @podfile = Pod::Podfile.new do
      platform :ios
      xcodeproj "dummy"
    end
    @target_definition = @podfile.target_definitions[:default]

    @sandbox = temporary_sandbox
    @pods = [Pod::LocalPod.new(fixture_spec("banana-lib/BananaLib.podspec"), @sandbox, Pod::Platform.ios)]
    copy_fixture_to_pod("banana-lib", @pods[0])
    @markdown = Pod::Generator::Markdown.new(@target_definition, @pods)
  end

  it "returns a correctly formatted title string" do
    @markdown.title_from_string("A Title").should.equal "A Title\n-------\n"
  end

  it "returns a correctly formatted license string for each pod" do
    @markdown.string_for_pod(@pods[0]).should.equal "BananaLib\n---------\nPermission is hereby granted ...\n"
  end

  it "returns a correctly formatted markdown string for the target" do
    @markdown.licenses.should.equal "Acknowledgements\n----------------\nThis application makes use of the following third party libraries:\nBananaLib\n---------\nPermission is hereby granted ...\nGenerated by CocoaPods - http://cocoapods.org\n"
  end
end
