# Do’s and Don’ts

Do’s:

* First **search for existing tickets** and add additional feedback if needed.
* Only file a ticket if it’s for a bug or feature request **pertaining to the CocoaPods tool itself**.
  (See the tools section below for more info.)
* Take the time to **provide all context you can imagine being needed**, but stay as succint as possible.
  Doing this means your ticket is more likely to receive the appropriate attention, or, as we say at
  Keeping-Sanity-in-OSS-HQ™: _“If you don’t care, we won’t care.”_

Don’ts:

* Do not file issues with **usage questions**. These are questions like how to create a podspec for your library or
  how to perform certain work with the command-line tools. Please submit these questions to either our
  [mailing-list](http://groups.google.com/group/cocoapods) or [StackOverflow](http://stackoverflow.com).
* Do not file issues **regarding a library you want added** to the CocoaPods spec repo. Instead, create a pull-request
  with your spec on the [CocoaPods/Specs](https://github.com/CocoaPods/Specs/issues) repo.
* Do not **just :+1: (upvote) issues** when none of the core members has asked for input from the community. If you really
  want a feature in, consider creating a patch and pull-request instead.

## Tools for which issues are allowed

The issues of this repository refer **only** to the development of the CocoaPods
tool. These resources include:

- [CocoaPods](https://github.com/CocoaPods/CocoaPods/issues)
- [CocoaPods/Core](https://github.com/CocoaPods/Core/issues)
- [Xcodeproj](https://github.com/CocoaPods/Xcodeproj/issues)


#### Bug reports

Please include _all_ relevant information, including the version of CocoaPods and
any template printed by the tool.

If questions in the error template are left unanswered, the issue will be closed
as a bad bug report.

If there is a regression in the projects generated by CocoaPods please include
the output (redacted if needed) of one of the following commands:

```
$ xcodeproj target-diff
$ xcodeproj project-diff
```

If you are familiar with Ruby, making a pull request with a failing test case
can speed up the resolution of the bug. If the issue is more complex you can
add an [integration test](https://github.com/CocoaPods/CocoaPods/tree/master/spec/integration)
which doesn't require any ruby knowledge.


#### Feature requests

Please try to be precise about the proposed outcome of the feature and how it
would related to existing features.


## Pull Requests

We **love** pull requests and if a contribution is significant we tend to offer
push access.

All contributions will be licenced under the MIT license.

