
#### 更美业务服务化拆分与序列化组件
* 适用场景一：业务拆分为独立服务时, 提供WeakRelField(弱关系外键)替代ForeignKey, 支持惰性加载，批量加载，ObjCache和RedisCache两层缓存；
* 适用场景二：对象序列化时，提供弱Schema，处理相关Field(包括WeakRelField);

#### 配置

> settings.py

```python
from rpc.context import get_gaia_local_invoker
RPC_INVOKER = get_gaia_local_invoker()
```

#### 使用示例

```python
from gm_serializer import serializers
from gm_serializer.models import WeakRelField


# 社区拆分之后，将 user(ForeignKey) 改为 WeakRelField
class Question(models.Model):
    user = WeakRelField(type=int, url='api/user/get_fundamental_info_by_user_ids', args='user_ids')
    title = models.CharField(max_length=128, null=False, verbose_name=u'问题')
    content = models.TextField(null=True, verbose_name=u'描述')


class QuestionSerializer(serializers.GmModelSerializer):
    user = serializers.WeakRelField(
        validators = [serializers.BlacklistValidator]
    )
    content = serializers.TextField(
        validators = [serializers.FilterWordValidator]
    )
    
    class Meta:
        model = Question
        lazy_fields = ('user',)
        fields = '__all__'
```

