
import json
import redis
from django.conf import settings


class _PoolMixin(object):
    _pool = redis.ConnectionPool(**settings.REDIS['gm_serializer'])
    _client = redis.Redis(connection_pool=_pool)


class WeakObjCache(_PoolMixin):

    prefix = ''

    def __init__(self, prefix):
        self.prefix = prefix

    def __getitem__(self, item):
        """

        :param item:
        :return:
        """
        key = "%s:%s" % (self.prefix, str(item))
        obj = self._client.get(key)
        return json.loads(obj) if obj else None

    def __setitem__(self, key, value):
        """

        :param key:
        :param value:
        :return:
        """
        key = "%s:%s" % (self.prefix, str(key))
        if isinstance(value, dict):
            value = json.dumps(value)
        return self._client.set(key, value, 30*60)



