
from gm_serializer.cache import WeakObjCache
from gm_serializer.logger import logger
from gm_serializer.utils import RPCMixin, DictWrapper


class WeakCacheManager(RPCMixin):

    def __init__(self, name=None, value=None, value_lst=None, url=None, args=None):
        self.name = name
        self.value = value
        self.value_lst = value_lst
        self.url = url
        self.args = args

    @property
    def cache(self):
        return WeakObjCache(self.name)

    def get_object(self):
        return self.cache[self.value]

    def get_queryset(self):
        values = filter(lambda i: i is not None, [self.cache[key] for key in set(self.value_lst)])
        if len(values) == len(set(self.value_lst)):
            return values
        return []


class WeakRelManager(WeakCacheManager):

    def get_object(self):
        """
        get object from remote rpc
        :return:
        """
        obj = super(WeakRelManager, self).get_object()

        if obj:
            logger.debug("WeakRel RedisCache: %s %s" % (self.name, self.value))
            return DictWrapper(obj)

        kwargs = {
            self.args: [self.value],
        }
        logger.debug("WeakRel RpcCall: %s %s=%s" % (self.url, self.args, self.value))
        obj = self.call_rpc(self.url, **kwargs)[0]
        self.cache[obj['id']] = obj
        return DictWrapper(obj)

    def get_queryset(self):
        queryset = super(WeakRelManager, self).get_queryset()
        if queryset:
            logger.debug("WeakRel RedisCache: %s %s" % (self.name, self.value_lst))
            return [DictWrapper(obj) for obj in queryset]

        kwargs = {
            self.args: self.value_lst,
        }
        logger.debug("WeakRel RpcCall: %s %s=%s" % (self.url, self.args, self.value_lst))
        data = self.call_rpc(self.url, **kwargs)

        for obj in data:
            self.cache[obj['id']] = obj

        return [DictWrapper(d) for d in data]
