
from gm_serializer.manager import DictWrapper
from gm_serializer.logger import logger


class WeakDescriptor(object):

    def __init__(self, field_with_rel):
        self.field = field_with_rel

    @property
    def cache_name(self):
        return "_%s_cache_" % self.field.attname

    @property
    def lazy_name(self):
        return "_%s_lazy_" % self.field.attname

    def __get__(self, instance, cls):
        """

        :param instance:
        :param cls:
        :return:
        """
        if instance is None:
            return self

        if getattr(instance, self.lazy_name, False):
            return getattr(instance, "%s_id" % self.field.attname)

        try:
            lazy_obj = getattr(instance, self.cache_name)
            logger.debug("WeakRel ObjCache: %s:%s" % (self.field.attname, lazy_obj['id']))
        except AttributeError:
            lazy_obj = self.field.relation.get_object()
            setattr(instance, self.cache_name, lazy_obj)
        return lazy_obj

    def __set__(self, instance, value):
        """

        :param instance:
        :param value:
        :return:
        """
        attname = self.field.attname
        relation = self.field.relation

        if value is None and self.field.null is False:
            raise ValueError("Null value not allowed.")

        if isinstance(value, DictWrapper):
            setattr(instance, self.cache_name, value)
            return

        setattr(relation, "name", attname)
        setattr(relation, "value", value)
        setattr(instance, "%s_id" % attname, value)

        if hasattr(instance, self.cache_name) and getattr(instance, self.cache_name)['id'] != value:
            obj_cache = self.field.relation.get_object()
            setattr(instance, "%s_id" % attname, value)
            setattr(instance, self.cache_name, obj_cache)


