from rest_framework import serializers

from gm_serializer.utils import RPCMixin


class BlacklistValidator(RPCMixin):
    def __call__(self, value):
        try:
            r = self.call_rpc('api/user/in_blacklist', user_id=value)
        except:
            return False

        if r:
            raise serializers.ValidationError("User in blacklist.")


class FilterWordValidator(RPCMixin):

    def __init__(self, filter_type=None):
        self.filter_type = filter_type

    def __call__(self, value):
        try:
            r = self.call_rpc('api/filterWord/list', filter_type=self.filter_type)
        except:
            return False
        if r:
            raise serializers.ValidationError("Content contains sensitive words.")



