
from django.conf import settings


class DictWrapper(dict):

    def __getattribute__(self, item):
        """

        :param item:
        :return:
        """
        if item in self:
            if isinstance(self[item], dict):
                return DictWrapper(self[item])
            return self[item]
        raise AttributeError


class RPCMixin(object):

    @classmethod
    def rpc_invoker(cls):
        return settings.RPC_INVOKER

    def call_rpc(self, api_endpoint, **kwargs):
        """call rpc.

        get rpc invoker from current ctx, this method only support call rpc sequentially.
        """
        result = self.rpc_invoker()[api_endpoint](**kwargs)
        return result.unwrap()


