#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import find_packages
from setuptools import setup
import os
import io
import re
import ast

# requirements
install_requires = [
    "djangorestframework==3.6.0",
    "redis",
    "django",
]


here = os.path.abspath(os.path.dirname(__file__))
with io.open(os.path.join(here, 'gm_serializer', '__init__.py')) as f:
    version = None
    for line in f.readlines():
        match = re.match(r"""__version__ *= *(.*)""", line)
        if not match:
            continue
        content = match.groups()[0]
        version = ast.literal_eval(content)


setup(name="gm-serializer",
      version=version,
      description="gengmei serializer",
      author="gushitong",
      author_email="gushitong@gmei.com",
      packages=find_packages(),
      url="http://git.gengmei.cc/gushitong/gm-serializer",
      install_requires=install_requires)
