from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import  expected_conditions as EC
import unittest
import time
from selenium.common.exceptions import NoSuchElementException
from appium_common import setUpDriver

brand_xpath = "/hierarchy/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.LinearLayout/" \
                   "android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.view.ViewGroup/" \
                   "android.support.v4.view.ViewPager/android.support.v7.widget.RecyclerView/" \
                   "android.widget.RelativeLayout[%d]"

def scroll(drv):
    t1 = time.time()
    drv.swipe(0, 600, 0, 0, 1000)
    t2 = time.time()
    print("scroll: %s" % (t2 - t1))

def getAllBrands():
    t1 = time.time()
    drv = setUpDriver()
    t2 = time.time()
    print("set up driver: %s" % (t2 - t1))
    done = []
    while True:
        t1 = time.time()
        brand = drv.find_element_by_xpath(brand_xpath % 1)
        t2 = time.time()
        print("find brand: %s" % (t2 - t1))

        try:

            t1 = time.time()
            brand_name = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_name")
            t2 = time.time()
            print("find name: %s" % (t2 - t1))

        except NoSuchElementException:
            brand_name = None
        try:

            t1 = time.time()
            brand_name_en = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_name_en")
            t2 = time.time()
            print("find english name: %s" % (t2 - t1))

        except NoSuchElementException:
            brand_name_en = None
        if brand_name is not None:
            if brand_name.text not in done:
                done.append(brand_name.text)
                print(brand_name.text)
                print(brand_name_en.text)
            else:
                scroll(drv)
                continue
        elif brand_name_en is not None:
            if brand_name_en.text not in done:
                done.append(brand_name_en.text)
                print(brand_name_en.text)
            else:
                scroll(drv)
                continue
        else:
            scroll(drv)
            continue

        t1 = time.time()
        brand_year = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_year")
        t2 = time.time()
        print("find year: %s" % (t2 - t1))
        print(brand_year.text)

        t1 = time.time()
        brand_desc = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_desc")
        t2 = time.time()
        print("find desc: %s" % (t2 - t1))

        print(brand_desc.text)
        scroll(drv)

if __name__=='__main__':
    getAllBrands()
