from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import  expected_conditions as EC
import unittest
import time
from selenium.common.exceptions import NoSuchElementException
from appium_common import setUpDriver

brand_xpath = "/hierarchy/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.LinearLayout/" \
                   "android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.view.ViewGroup/" \
                   "android.support.v4.view.ViewPager/android.support.v7.widget.RecyclerView/" \
                   "android.widget.RelativeLayout[%d]"

def getAllBrands():
    drv = setUpDriver()
    done = []
    while True:
        brand = drv.find_element_by_xpath(brand_xpath % 1)
        try:
            brand_name = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_name")
        except NoSuchElementException:
            brand_name = None
        try:
            brand_name_en = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_name_en")
        except NoSuchElementException:
            brand_name_en = None
        if brand_name is not None:
            if brand_name.text not in done:
                done.append(brand_name.text)
                print(brand_name.text)
                print(brand_name_en.text)
            else:
                drv.swipe(0, 600, 0, 0, 1000)
                continue
        elif brand_name_en is not None:
            if brand_name_en.text not in done:
                done.append(brand_name_en.text)
                print(brand_name_en.text)
            else:
                drv.swipe(0, 600, 0, 0, 1000)
                continue
        else:
            drv.swipe(0, 600, 0, 0, 1000)
            continue
        brand_year = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_year")
        print(brand_year.text)
        brand_desc = brand.find_element_by_id("org.c2h4.afei.beauty:id/tv_desc")
        print(brand_desc.text)
        drv.swipe(0, 600, 0, 0, 1000)

if __name__=='__main__':
    getAllBrands()
