from appium import webdriver

def get_desired_capabilities():
    desired_caps = {
        "platformName": "Android",
        "deviceName": "Redmi Note 4X",
        "udid": "d52196830204",
        "automationName": "uiautomator2",
        "appActivity": ".ui.LauncherUI",
        "noReset": "True",
        "waitForQuiescence": "false",
        "useJSONSource": "true",
        "simpleIsVisibleCheck": "true"
    }
    return desired_caps

def get_uri():
    return 'http://localhost:4723/wd/hub'

def setUpDriver():
    desired_cap = get_desired_capabilities()
    print(desired_cap)
    uri = get_uri()
    driver = webdriver.Remote(uri, desired_cap)
    return driver