
/**
 * Created by feeling on 17/12/7.
 */
import db.*;
import io.dropwizard.Application;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import config.MonitorConfiguration;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.util.StringMapper;
import resources.HBaseMetastoreResource;
import resources.HelloWorldResource;
import health.TemplateHealthCheck;
import resources.HiveMetastoreResource;
import resources.TemplateResource;
import tasks.EchoTask;
import utils.DBInstanceManager;

import javax.sql.DataSource;
import java.sql.*;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ServerApplication extends Application<MonitorConfiguration>{
    public static void main(String[] args) throws Exception {
        new ServerApplication().run(args);
    }

    @Override
    public String getName() {
        return "hello-world";
    }

    @Override
    public void initialize(Bootstrap<MonitorConfiguration> bootstrap) {
        // nothing to do yet
    }

    @Override
    public void run(MonitorConfiguration configuration,
                    Environment environment) throws ClassNotFoundException,SQLException {
        try {
            String driverName = "org.apache.hive.jdbc.HiveDriver";
            Class.forName(driverName);


        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        final DBI hbaseDbi = new DBIFactory().build(environment, configuration.getHbaseDatabase(), "hbase");
        final DBI zhengxingDbi = new DBIFactory().build(environment, configuration.getZhengxingDatabase(), "zhengxing");
        final DBI marsDbi = new DBIFactory().build(environment, configuration.getMarsDatabase(), "mars");
        final DBI hiveDbi = new DBIFactory().build(environment, configuration.getHiveDatabase(), "hive");
        final DBI hiveMetastoreDBi = new DBIFactory().build(environment, configuration.getHiveMetastore(), "hiveMeta");


        final HashMap<String, DBI> dbiMap = new HashMap<String, DBI>(){{
            put("hbase", hbaseDbi);
            put("mars", marsDbi);
            put("zhengxing", zhengxingDbi);
            put("hive", hiveDbi);
            put("hiveMeta", hiveMetastoreDBi);
        }};
        this.registerDAO(dbiMap);

//        final TemplateHealthCheck healthCheck = new TemplateHealthCheck(configuration.getTemplate());
//        environment.healthChecks().register("template", healthCheck);
        final HelloWorldResource resource = new HelloWorldResource(
                configuration.getTemplate(),
                configuration.getDefaultName()
        );
        environment.admin().addTask(new EchoTask());
        environment.jersey().register(resource);
        environment.jersey().register(new TemplateResource(dbiMap));
        environment.jersey().register(new HiveMetastoreResource(dbiMap));
        environment.jersey().register(new HBaseMetastoreResource(dbiMap));
    }

    private void registerDAO(HashMap<String, DBI> dbiHashMap) {

        DAOManager.INSTANCE.addDAO(TemplateDAO.class, dbiHashMap.get("mars"));
        DAOManager.INSTANCE.addDAO(TemplateResultDAO.class, dbiHashMap.get("mars"));
        DAOManager.INSTANCE.addDAO(TemplateUserDAO.class, dbiHashMap.get("mars"));
        DAOManager.INSTANCE.addDAO(TemplateCustomSqlDAO.class, dbiHashMap.get("mars"));
        DAOManager.INSTANCE.addDAO(CustomMetaDataDAO.class, dbiHashMap.get("mars"));
        DAOManager.INSTANCE.addDAO(MarsUserDAO.class, dbiHashMap.get("zhengxing"));
        DAOManager.INSTANCE.addDAO(HiveMetaColumnDAO.class, dbiHashMap.get("hiveMeta"));
        DAOManager.INSTANCE.addDAO(HiveMetaTblDAO.class, dbiHashMap.get("hiveMeta"));


    }

    private void testConnectHive() throws SQLException {
        try {
            String driverName = "org.apache.hive.jdbc.HiveDriver";
            Class.forName(driverName);


        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        String showTableSql = "show tables";
        Connection con = DriverManager.getConnection("jdbc:hive2://127.0.0.1:10000/default", "feeling", "");

        PreparedStatement stmt = con.prepareStatement(showTableSql);
        ResultSet resultSet = stmt.executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1));
        }
    }
}
