package config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import io.dropwizard.db.DataSourceFactory;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * Created by feeling on 17/12/14.
 */
public class MonitorConfiguration extends Configuration {
    @NotEmpty
    private String template;

    @NotEmpty
    private String defaultName = "Stranger";

    @JsonProperty
    public String getTemplate() {
        return template;
    }

    @JsonProperty
    public void setTemplate(String template) {
        this.template = template;
    }

    @JsonProperty
    public String getDefaultName() {
        return defaultName;
    }

    @JsonProperty
    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    @Valid
    @NotNull
    @JsonProperty("marsDatabase")
    private DataSourceFactory marsDatabase = new DataSourceFactory();

    public DataSourceFactory getMarsDatabase() {
        return marsDatabase;
    }


    @Valid
    @NotNull
    @JsonProperty("hbaseDatabase")
    private DataSourceFactory hbaseDatabase = new DataSourceFactory();

    public  DataSourceFactory getHbaseDatabase() {
        return hbaseDatabase;
    }

    @Valid
    @NotNull
    @JsonProperty("zhengxingDatabase")
    private DataSourceFactory zhengxingDatabase = new DataSourceFactory();

    public  DataSourceFactory getZhengxingDatabase() {
        return zhengxingDatabase;
    }

    @Valid
    @NotNull
    @JsonProperty("hiveDatabase")
    private DataSourceFactory hiveDatabase = new DataSourceFactory();

    public DataSourceFactory getHiveDatabase() {
        return hiveDatabase;
    }

    @Valid
    @NotNull
    @JsonProperty("hiveMetastore")
    private DataSourceFactory hiveMetastore = new DataSourceFactory();

    public DataSourceFactory getHiveMetastore() {
        return hiveMetastore;
    }
}
