package db;

import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import pojo.mapper.CustomMetaDataMapper;
import pojo.model.CustomMetaData;

import java.util.List;

/**
 * Created by feeling on 17/12/22.
 */
public interface CustomMetaDataDAO {

    @SqlQuery("select * from monitor_metadata where id =:id and is_delete =:is_delete")
    @RegisterMapper(CustomMetaDataMapper.class)
    CustomMetaData getDataById(@Bind("id") Integer id, @Bind("is_delete") Integer isDelete);

    @SqlQuery("select * from monitor_metadata where is_delete =:is_delete")
    @RegisterMapper(CustomMetaDataMapper.class)
    List<CustomMetaData> getAll(@Bind("is_delete") Integer isDelete);

    @SqlUpdate("update monitor_metadata set name =:name, column_name=:column_name, source=:source, source_table=:source_table, filters=:filters, groups=:groups, aggregate_function=:aggregate_function where id=:id")
    void updateMetaData(@Bind("id") Integer id,@Bind("name") String name, @Bind("column_name") String columnName, @Bind("source") String source, @Bind("source_table") String SourceTable, @Bind("filters") String filters, @Bind("groups") String groups, @Bind("aggregate_function") String aggFunction);

    @SqlUpdate("insert into monitor_metadata (name, column_name, source, source_table, filters, groups, aggregate_function) values (:name, :column_name, :source, :source_table, :filters, :groups, :aggregate_function)")
    @GetGeneratedKeys
    int insertMetaData(@Bind("name") String name, @Bind("column_name") String columnName, @Bind("source") String source, @Bind("source_table") String SourceTable, @Bind("filters") String filters, @Bind("groups") String groups, @Bind("aggregate_function") String aggFunction);

}